package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.AnimationContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.util.Color;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.extended.LivingEntityRendererAccessor;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.model.provider.data.EntityModelData;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.EModelRenderCycle;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.IRenderCycle;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import java.util.Collections;
import java.util.List;

@SuppressWarnings({"rawtypes", "unchecked"})
public abstract class GeoReplacedEntityRenderer<T extends class_1309, E extends AnimatableEntity<T>> extends class_922<T, class_572<T>> implements IGeoRenderer<T> {
    protected final List<GeoLayerRenderer> layerRenderers = new ObjectArrayList<>();
    protected AnimatableEntity<T> currentAnimatable;
    protected float widthScale = 1;
    protected float heightScale = 1;
    protected Matrix4f dispatchedMat = new Matrix4f();
    protected Matrix4f renderEarlyMat = new Matrix4f();
    protected class_4597 rtb = null;
    private IRenderCycle currentModelRenderCycle = EModelRenderCycle.INITIAL;

    public GeoReplacedEntityRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new class_572<>(renderManager.method_32167(class_5602.field_27577)), 0.5f);
    }

    public static int getPackedOverlay(class_1309 entity, float u) {
        return class_4608.method_23625(class_4608.method_23210(u), class_4608.method_23212(entity.field_6235 > 0 || entity.field_6213 > 0));
    }

    private static float getFacingAngle(class_2350 facingIn) {
        return switch (facingIn) {
            case field_11035 -> 90;
            case field_11043 -> 270;
            case field_11034 -> 180;
            default -> 0;
        };
    }

    private static void renderLeashPiece(class_4588 buffer, Matrix4f positionMatrix, float xDif, float yDif,
                                         float zDif, int entityBlockLight, int holderBlockLight, int entitySkyLight,
                                         int holderSkyLight, float width, float yOffset, float xOffset, float zOffset, int segment, boolean isLeashKnot) {
        float piecePosPercent = segment / 24f;
        int lerpBlockLight = (int) class_3532.method_16439(piecePosPercent, entityBlockLight, holderBlockLight);
        int lerpSkyLight = (int) class_3532.method_16439(piecePosPercent, entitySkyLight, holderSkyLight);
        int packedLight = class_765.method_23687(lerpBlockLight, lerpSkyLight);
        float knotColourMod = segment % 2 == (isLeashKnot ? 1 : 0) ? 0.7f : 1f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = xDif * piecePosPercent;
        float y = yDif > 0.0f ? yDif * piecePosPercent * piecePosPercent : yDif - yDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = zDif * piecePosPercent;

        buffer.method_22918(positionMatrix, x - xOffset, y + yOffset, z + zOffset).method_22915(red, green, blue, 1).method_60803(packedLight);
        buffer.method_22918(positionMatrix, x + xOffset, y + width - yOffset, z - zOffset).method_22915(red, green, blue, 1).method_60803(packedLight);
    }

    @Override
    @Nonnull
    public IRenderCycle getCurrentModelRenderCycle() {
        return this.currentModelRenderCycle;
    }

    @Override
    public void setCurrentModelRenderCycle(IRenderCycle currentModelRenderCycle) {
        this.currentModelRenderCycle = currentModelRenderCycle;
    }

    @Override
    public float getWidthScale(T animatable) {
        return this.widthScale;
    }

    @Override
    public float getHeightScale(T entity) {
        return this.heightScale;
    }

    @Override
    public void renderEarly(T animatable, class_4587 poseStack, float partialTick,
                            class_4597 bufferSource, class_4588 buffer, int packedLight, int packedOverlayIn,
                            float red, float green, float blue, float alpha) {
        this.renderEarlyMat = new Matrix4f(poseStack.method_23760().method_23761());
        IGeoRenderer.super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlayIn, red, green, blue, alpha);
    }

    @Override
    public void method_4054(T entity, float entityYaw, float partialTick, class_4587 poseStack,
                       class_4597 bufferSource, int packedLight) {

        render(entity, getAnimatableEntity(entity), entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void render(T entity, E animatable, float entityYaw, float partialTick, class_4587 poseStack,
                       class_4597 bufferSource, int packedLight) {
        this.currentAnimatable = animatable;
        this.dispatchedMat = new Matrix4f(poseStack.method_23760().method_23761());
        boolean shouldSit = entity.method_5765() && (entity.method_5854() != null /*&& entity.getVehicle().shouldRiderSit()*/);

        setCurrentModelRenderCycle(EModelRenderCycle.INITIAL);

/*        if (NeoForge.EVENT_BUS.post(new RenderLivingEvent.Pre<>(entity, this, partialTick, poseStack, bufferSource, packedLight)).isCanceled()) {
            return;
        }*/

        poseStack.method_22903();
        if (entity instanceof class_1308 mob) {
            class_1297 leashHolder = mob.method_60952();
            if (leashHolder != null) {
                renderLeash(entity, partialTick, poseStack, bufferSource, leashHolder);
            }
        }

        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = shouldSit;
        entityModelData.isChild = entity.method_6109();

        float lerpBodyRot = class_3532.method_17821(partialTick, entity.field_6220, entity.field_6283);
        float lerpHeadRot = class_3532.method_17821(partialTick, entity.field_6259, entity.field_6241);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;

        if (shouldSit && entity.method_5854() instanceof class_1309 vehicle) {
            lerpBodyRot = class_3532.method_17821(partialTick, vehicle.field_6220, vehicle.field_6283);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = class_3532.method_15363(class_3532.method_15393(netHeadYaw), -85, 85);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }

        if (entity.method_18376() == class_4050.field_18078) {
            class_2350 direction = entity.method_18401();
            if (direction != null) {
                float eyeOffset = entity.method_18381(class_4050.field_18076) - 0.1f;
                poseStack.method_46416(-direction.method_10148() * eyeOffset, 0, -direction.method_10165() * eyeOffset);
            }
        }

        float lerpedAge = entity.field_6012 + partialTick;
        float limbSwingAmount = 0;
        float limbSwing = 0;

        method_4058(entity, poseStack, lerpedAge, lerpBodyRot, partialTick, entity.method_55693());
        preRenderCallback(entity, poseStack, partialTick);
        if (!shouldSit && entity.method_5805()) {
            limbSwingAmount = entity.field_42108.method_48570(partialTick);
            limbSwing = entity.field_42108.method_48572(partialTick);
            if (entity.method_6109()) {
                limbSwing *= 3.0F;
            }
        }

        float headPitch = class_3532.method_16439(partialTick, entity.field_6004, entity.method_36455());
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -class_3532.method_15363(class_3532.method_15393(netHeadYaw), -85, 85);
        AnimationEvent predicate = new AnimationEvent(animatable, limbSwing, limbSwingAmount, partialTick,
                (limbSwingAmount <= -getSwingMotionAnimThreshold() || limbSwingAmount <= getSwingMotionAnimThreshold()), Collections.singletonList(entityModelData));
        AnimationContext<?> ctx = new AnimationContext<>(entity, this.currentAnimatable, predicate, entityModelData);
        animatable.setCustomAnimations(ctx, predicate);
        AnimatedGeoModel model = animatable.getCurrentModel();
        if (model != null) {
            poseStack.method_46416(0, 0.01f, 0);
            RenderSystem.setShaderTexture(0, getTextureLocation(entity));

            Color renderColor = getRenderColor(entity, partialTick, poseStack, bufferSource, null, packedLight);
            class_1921 renderType = getRenderType(entity, partialTick, poseStack, bufferSource, null, packedLight,
                    getTextureLocation(entity));

            if (class_310.method_1551().field_1724 != null && !entity.method_5756(class_310.method_1551().field_1724)) {
                class_4588 translucentBuffer = bufferSource.getBuffer(class_1921.method_23578(getTextureLocation(entity)));
                render(model, entity, partialTick, renderType, poseStack, bufferSource, translucentBuffer,
                        packedLight, getPackedOverlay(entity, getOverlayProgress(entity, partialTick)),
                        renderColor.getRed() / 255f, renderColor.getGreen() / 255f,
                        renderColor.getBlue() / 255f, renderColor.getAlpha() / 255f);
            }
        }
        if (!entity.method_7325()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                layerRenderer.render(poseStack, bufferSource, packedLight, entity, limbSwing, limbSwingAmount, partialTick,
                        lerpedAge, netHeadYaw, headPitch);
            }
        }
        poseStack.method_22909();

        ((LivingEntityRendererAccessor) this).tlm$renderNameTag(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        //NeoForge.EVENT_BUS.post(new RenderLivingEvent.Post<>(entity, this, partialTick, poseStack, bufferSource, packedLight));
    }

    protected float getOverlayProgress(class_1309 entity, float partialTicks) {
        return 0.0F;
    }

    protected void preRenderCallback(class_1309 entity, class_4587 poseStack, float partialTick) {
    }

    @Override
    @NotNull
    public class_2960 getTextureLocation(T entity) {
        return this.getAnimatableEntity(entity).getTextureLocation();
    }

    @Override
    protected void method_4058(T pEntityLiving, class_4587 pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks, float pScale) {
        super.method_4058(pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks, pScale);
        if (pEntityLiving.field_6213 <= 0 && pEntityLiving.method_6123()) {
            pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(((float) pEntityLiving.field_6012 + pPartialTicks) * 75.0F));
            pPoseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0F + pEntityLiving.method_36455()));
        }
    }

    protected boolean isVisible(class_1309 entity) {
        return !entity.method_5767();
    }

    protected float getDeathMaxRotation(class_1309 entity) {
        return 90;
    }

    @Override
    public boolean method_4055(T entity) {
        double nameRenderDistance = entity.method_21751() ? 32d : 64d;
        if (this.field_4676.method_23168(entity) >= nameRenderDistance * nameRenderDistance) {
            return false;
        }
        return entity.method_5733() || (entity == this.field_4676.field_4678 && entity.method_16914())
                && class_310.method_1498();
    }

    protected float getSwingProgress(class_1309 entity, float partialTick) {
        return entity.method_6055(partialTick);
    }

    protected float getSwingMotionAnimThreshold() {
        return 0.15f;
    }

    public final boolean addLayer(GeoLayerRenderer<T, ?> layer) {
        return this.layerRenderers.add(layer);
    }

    public abstract E getAnimatableEntity(T entity);

    public <E extends class_1297> void renderLeash(T entity, float partialTick, class_4587 poseStack,
                                               class_4597 bufferSource, E leashHolder) {
        double lerpBodyAngle = (class_3532.method_16439(partialTick, entity.field_6283, entity.field_6220) * class_3532.field_29847) + class_3532.field_29845;
        class_243 leashOffset = entity.method_45321(1.0f);
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.field_1350 + Math.sin(lerpBodyAngle) * leashOffset.field_1352;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.field_1350 - Math.cos(lerpBodyAngle) * leashOffset.field_1352;
        double lerpOriginX = class_3532.method_16436(partialTick, entity.field_6014, entity.method_23317()) + xAngleOffset;
        double lerpOriginY = class_3532.method_16436(partialTick, entity.field_6036, entity.method_23318()) + leashOffset.field_1351;
        double lerpOriginZ = class_3532.method_16436(partialTick, entity.field_5969, entity.method_23321()) + zAngleOffset;
        class_243 ropeGripPosition = leashHolder.method_30951(partialTick);
        float xDif = (float) (ropeGripPosition.field_1352 - lerpOriginX);
        float yDif = (float) (ropeGripPosition.field_1351 - lerpOriginY);
        float zDif = (float) (ropeGripPosition.field_1350 - lerpOriginZ);
        float offsetMod = (float) class_3532.method_15345(xDif * xDif + zDif * zDif) * 0.025f / 2f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23587());
        class_2338 entityEyePos = class_2338.method_49638(entity.method_5836(partialTick));
        class_2338 holderEyePos = class_2338.method_49638(leashHolder.method_5836(partialTick));
        int entityBlockLight = method_24087(entity, entityEyePos);
        int holderBlockLight = leashHolder.method_5809() ? 15 : leashHolder.method_37908().method_8314(class_1944.field_9282, holderEyePos);
        int entitySkyLight = entity.method_37908().method_8314(class_1944.field_9284, entityEyePos);
        int holderSkyLight = entity.method_37908().method_8314(class_1944.field_9284, holderEyePos);

        poseStack.method_22903();
        poseStack.method_22904(xAngleOffset, leashOffset.field_1351, zAngleOffset);
        Matrix4f posMatrix = poseStack.method_23760().method_23761();
        for (int segment = 0; segment <= 24; ++segment) {
            renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight,
                    entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (int segment = 24; segment >= 0; --segment) {
            renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight,
                    entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        poseStack.method_22909();
    }

    @Override
    public class_4597 getCurrentRTB() {
        return this.rtb;
    }

    @Override
    public void setCurrentRTB(class_4597 bufferSource) {
        this.rtb = bufferSource;
    }

    public List<GeoLayerRenderer> getLayerRenderers() {
        return layerRenderers;
    }
}
