package com.github.tartaricacid.touhoulittlemaid.geckolib3.util;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.IContext;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.class_1304;
import net.minecraft.class_2960;

public class MolangUtils {
    private static final HashMap<String, class_1304> SLOT_MAP;

    static {
        SLOT_MAP = new HashMap<>();
        SLOT_MAP.put("chest", class_1304.field_6174);
        SLOT_MAP.put("feet", class_1304.field_6166);
        SLOT_MAP.put("head", class_1304.field_6169);
        SLOT_MAP.put("legs", class_1304.field_6172);
        SLOT_MAP.put("mainhand", class_1304.field_6173);
        SLOT_MAP.put("offhand", class_1304.field_6171);
    }

    public static float normalizeTime(long timestamp) {
        return ((float) (timestamp + 6000L) / 24000) % 1;
    }

    public static class_2960 parseResourceLocation(IContext<?> context, String value) {
        return class_2960.method_12829(value);
    }

    public static class_1304 parseSlotType(IContext<?> context, String value) {
        if (value == null) {
            return null;
        }
        return SLOT_MAP.get(value.toLowerCase(Locale.ENGLISH));
    }
}
