package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.FoxScrollPackage;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ItemFoxScroll extends class_1792 {
    public ItemFoxScroll() {
        super((new class_1793()).method_7889(1));
    }

    public static void setTrackInfo(class_1799 scroll, String dimension, class_2338 pos) {
        scroll.method_57379(InitDataComponent.TRACK_INFO, new TrackInfo(dimension, pos));
    }

    @Nullable
    public static TrackInfo getTrackInfo(class_1799 scroll) {
        return scroll.method_57824(InitDataComponent.TRACK_INFO);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        if (!level.field_9236 && hand == class_1268.field_5808) {
            class_1799 item = player.method_6047();
            MaidWorldData maidWorldData = MaidWorldData.get(level);
            if (maidWorldData == null) {
                return super.method_7836(level, player, hand);
            }
            Map<String, List<FoxScrollPackage.FoxScrollData>> data = Maps.newHashMap();
            List<MaidInfo> maidInfos = null;
            if (item.method_7909() == InitItems.RED_FOX_SCROLL) {
                maidInfos = maidWorldData.getPlayerMaidInfos(player);
            } else if (item.method_7909() == InitItems.WHITE_FOX_SCROLL) {
                maidInfos = maidWorldData.getPlayerMaidTombstones(player);
            }
            if (maidInfos == null) {
                maidInfos = Collections.emptyList();
            }
            maidInfos.forEach(info -> {
                List<FoxScrollPackage.FoxScrollData> scrollData = data.computeIfAbsent(info.getDimension(), dim -> Lists.newArrayList());
                scrollData.add(new FoxScrollPackage.FoxScrollData(info.getChunkPos(), info.getName(), info.getTimestamp()));
            });
            ServerPlayNetworking.send((class_3222) player, new FoxScrollPackage(data));
            if (player instanceof class_3222 serverPlayer) {
                if (item.method_7909() == InitItems.RED_FOX_SCROLL) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_RED_FOX_SCROLL);
                } else if (item.method_7909() == InitItems.WHITE_FOX_SCROLL) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_WHITE_FOX_SCROLL);
                }
            }
            return class_1271.method_22427(item);
        }
        return super.method_7836(level, player, hand);
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 worldIn, List<class_2561> components, class_1836 flagIn) {
        TrackInfo info = getTrackInfo(stack);
        if (info != null) {
            components.add(class_2561.method_43469("tooltips.touhou_little_maid.fox_scroll.dimension", info.dimension).method_27692(class_124.field_1065));
            components.add(class_2561.method_43469("tooltips.touhou_little_maid.fox_scroll.position", info.position.method_23854()).method_27692(class_124.field_1061));
            components.add(class_2561.method_43473());
        }
        if (stack.method_7909() == InitItems.RED_FOX_SCROLL) {
            components.add(class_2561.method_43471("tooltips.touhou_little_maid.fox_scroll.red").method_27692(class_124.field_1080));
        } else if (stack.method_7909() == InitItems.WHITE_FOX_SCROLL) {
            components.add(class_2561.method_43471("tooltips.touhou_little_maid.fox_scroll.white").method_27692(class_124.field_1080));
        }
        super.method_7851(stack, worldIn, components, flagIn);
    }

    public record TrackInfo(String dimension, class_2338 position) {
        public static final Codec<TrackInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group(
                Codec.STRING.fieldOf("dimension").forGetter(TrackInfo::dimension),
                class_2338.field_25064.fieldOf("position").forGetter(TrackInfo::position)
        ).apply(instance, TrackInfo::new));

        public static final class_9139<ByteBuf, TrackInfo> STREAM_CODEC = class_9139.method_56435(
                class_9135.field_48554, TrackInfo::dimension,
                class_2338.field_48404, TrackInfo::position,
                TrackInfo::new
        );
    }
}
