package com.github.tartaricacid.touhoulittlemaid.item;

import cn.sh1rocu.touhoulittlemaid.api.extension.IItemRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity.TileEntityItemStackGarageKitRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.inventory.tooltip.YsmMaidInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.serialization.Codec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_756;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import java.util.Objects;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.ENTITY_ID_TAG_NAME;
import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.MODEL_ID_TAG_NAME;

public class ItemGarageKit extends class_1747 implements IItemRenderer {
    @Environment(EnvType.CLIENT)
    @Override
    public class_756 getCustomRenderer() {
        class_310 minecraft = class_310.method_1551();
        return new TileEntityItemStackGarageKitRenderer(minecraft.method_31975(), minecraft.method_31974());
    }

    private static final String DEFAULT_ENTITY_ID = "touhou_little_maid:maid";
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private static final class_9279 DEFAULT_DATA = getDefaultData();

    public ItemGarageKit() {
        super(InitBlocks.GARAGE_KIT, (new class_1792.class_1793()).method_7889(1));
    }

    public static class_9279 getMaidData(class_1799 stack) {
        return Objects.requireNonNullElse(stack.method_57824(InitDataComponent.MAID_INFO), DEFAULT_DATA);
    }

    private static class_9279 getDefaultData() {
        class_2487 data = new class_2487();
        data.method_10582(ENTITY_ID_TAG_NAME, DEFAULT_ENTITY_ID);
        data.method_10582(MODEL_ID_TAG_NAME, DEFAULT_MODEL_ID);
        // 默认数据需要强制指定 YSM 渲染为空
        data.method_10556(EntityMaid.IS_YSM_MODEL_TAG, false);
        return class_9279.method_57456(data);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public class_2561 method_7864(class_1799 stack) {
        // 仅在客户端添加这个名称
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && class_310.method_1551().field_1687 != null) {
            // 手办名字前缀
            class_5250 prefix = class_2561.method_43471("block.touhou_little_maid.garage_kit.prefix");
            class_9279 data = getMaidData(stack);

            String entityId = data.method_57446(Codec.STRING.fieldOf(ENTITY_ID_TAG_NAME)).result().orElse(DEFAULT_ENTITY_ID);
            // 如果是其他实体，那么不需要显示 model id
            if (!entityId.equals(DEFAULT_ENTITY_ID)) {
                class_1299<?> entityType = class_7923.field_41177.method_10223(class_2960.method_60654(entityId));
                return prefix.method_10852(entityType.method_5897());
            }

            // 优先使用 YSM 模型名称
            if (YsmCompat.isInstalled()) {
                YsmMaidInfo ysmMaidInfo = YsmCompat.getYsmMaidInfo(data.method_57461());
                if (ysmMaidInfo.isYsmModel()) {
                    class_5250 name = class_2561.class_2562.method_10877(ysmMaidInfo.name(), class_310.method_1551().field_1687.method_30349());
                    if (name == null || name.equals(class_2561.method_43473())) {
                        return prefix.method_27693(ysmMaidInfo.modelId());
                    }
                    return prefix.method_10852(name);
                }
            }

            // 然后才是默认模型名
            String modelId = data.method_57446(Codec.STRING.fieldOf(MODEL_ID_TAG_NAME)).result().orElse(DEFAULT_MODEL_ID);
            MaidModelInfo info = CustomPackLoader.MAID_MODELS.getInfo(modelId).orElse(null);
            if (info != null) {
                return prefix.method_10852(ParseI18n.parse(info.getName()));
            }
            return super.method_7864(stack);
        }
        return super.method_7864(stack);
    }
}
