package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;

public class ItemMagnetBauble implements IMaidBauble {
    private static final int DELAY = 3 * 20;
    private static final int RANGE = 6;

    @Override
    public void onTick(EntityMaid maid, class_1799 baubleItem) {
        if (maid.field_6012 % DELAY == 0) {
            handlePickup(maid);
        }
    }

    private void handlePickup(EntityMaid maid) {
        class_1937 world = maid.method_37908();
        if (maid.isPickup() && maid.method_6181()) {
            List<class_1297> entities = world.method_8333(maid, maid.method_5829().method_1014(RANGE), maid::canPickup);
            if (!entities.isEmpty() && maid.method_5805()) {
                for (class_1297 entityPickup : entities) {
                    // 如果是物品
                    if (entityPickup instanceof class_1542) {
                        maid.pickupItem((class_1542) entityPickup, false);
                    }
                    // 如果是经验
                    if (entityPickup instanceof class_1303) {
                        maid.pickupXPOrb((class_1303) entityPickup);
                    }
                    // 如果是 P 点
                    if (entityPickup instanceof EntityPowerPoint) {
                        maid.pickupPowerPoint((EntityPowerPoint) entityPickup);
                    }
                    // 如果是箭
                    if (entityPickup instanceof class_1665) {
                        maid.pickupArrow((class_1665) entityPickup, false);
                    }
                }
                if (maid.method_35057() instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_ITEM_MAGNET_BAUBLE);
                }
            }
        }
    }
}
