package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidDeathEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_3222;
import net.minecraft.class_6024;
import net.minecraft.class_8103;

import static cn.sh1rocu.touhoulittlemaid.TouhouLittleMaidFabric.HIGH;

public class UndyingTotemBauble implements IMaidBauble {
    public UndyingTotemBauble() {
        MaidDeathEvent.CALLBACK.register(HIGH, this::onLivingDamage);
    }

    public void onLivingDamage(MaidDeathEvent event) {
        EntityMaid maid = event.getMaid();
        class_1282 source = event.getSource();
        if (!source.method_48789(class_8103.field_42242)) {
            int slot = ItemsUtil.getBaubleSlotInMaid(maid, this);
            if (slot >= 0) {
                maid.getMaidBauble().getStackInSlot(slot).method_7934(1);
                event.setCanceled(true);
                maid.method_6033(1.0F);
                maid.method_6012();
                maid.method_6092(new class_1293(class_1294.field_5924, 900, 1));
                maid.method_6092(new class_1293(class_1294.field_5898, 100, 1));
                maid.method_6092(new class_1293(class_1294.field_5918, 800, 0));
                maid.field_6002.method_8421(maid, class_6024.field_30003);
                if (maid.method_35057() instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.USE_UNDEAD_BAUBLE);
                }
            }
        }
    }
}
