package com.github.tartaricacid.touhoulittlemaid.loot;

import cn.sh1rocu.touhoulittlemaid.api.extension.ILootContext;
import cn.sh1rocu.touhoulittlemaid.mixin.accessor.LootContextParamSetsAccessor;
import com.github.tartaricacid.touhoulittlemaid.init.InitLootCondition;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_176;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import net.minecraft.class_7924;
import java.util.Objects;
import java.util.Optional;

public record LootTableTypeCondition(class_2960 lootTableType,
                                     @Nullable class_5321<class_52> lootTableId,
                                     class_5321<class_52> lootTableAdd) implements class_5341 {
    public static final MapCodec<LootTableTypeCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_2960.field_25139.fieldOf("loot_table_type").forGetter(m -> m.lootTableType),
            class_5321.method_39154(class_7924.field_50079).optionalFieldOf("loot_table_id").forGetter(m -> Optional.ofNullable(m.lootTableId)),
            class_5321.method_39154(class_7924.field_50079).fieldOf("loot_table_add").forGetter(m -> m.lootTableAdd)
    ).apply(instance, (type, id, add)
            -> new LootTableTypeCondition(type, id.orElse(null), add)));

    @Override
    public boolean test(class_47 context) {
        class_2960 currentLootTable = ((ILootContext) context).tlm$getQueriedLootTableId();
        return !currentLootTable.equals(lootTableAdd.method_29177()) && typeAreEquals(context) && idAreEquals(context);
    }

    private boolean typeAreEquals(class_47 context) {
        class_5321<class_52> currentLootTable = class_5321.method_29179(class_7924.field_50079, ((ILootContext) context).tlm$getQueriedLootTableId());
        class_176 lootContextParamSet = LootContextParamSetsAccessor.tlm$getRegistry().get(lootTableType);
        return context.method_51183().method_58561(class_7924.field_50079, currentLootTable).map(lootTable ->
                        Objects.equals(lootTable.comp_349().method_322(), lootContextParamSet))
                .orElse(false);
    }

    private boolean idAreEquals(class_47 context) {
        if (this.lootTableId == null) {
            return true;
        }
        return ((ILootContext) context).tlm$getQueriedLootTableId().equals(this.lootTableId.method_29177());
    }

    @Override
    public @NotNull class_5342 method_29325() {
        return InitLootCondition.LOOT_TABLE_TYPE;
    }
}