package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record BeaconAbsorbPackage(float x, float y, float z) implements class_8710 {
    public static final class_8710.class_9154<BeaconAbsorbPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("beacon_absorb"));
    public static final class_9139<ByteBuf, BeaconAbsorbPackage> STREAM_CODEC = class_9139.method_56436(
            class_9135.field_48552,
            BeaconAbsorbPackage::x,
            class_9135.field_48552,
            BeaconAbsorbPackage::y,
            class_9135.field_48552,
            BeaconAbsorbPackage::z,
            BeaconAbsorbPackage::new
    );

    public static void handle(BeaconAbsorbPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> spawnParticle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void spawnParticle(BeaconAbsorbPackage message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null) {
            EntityPowerPoint.spawnExplosionParticle(mc.field_1687, message.x, message.y, message.z, mc.field_1687.field_9229);
        }
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
