package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.item.ItemServantBell;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record ServantBellSetPackage(int id, String tip) implements class_8710 {
    public static final class_8710.class_9154<ServantBellSetPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("servant_bell_set"));
    public static final class_9139<ByteBuf, ServantBellSetPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_49675,
            ServantBellSetPackage::id,
            class_9135.field_48554,
            ServantBellSetPackage::tip,
            ServantBellSetPackage::new
    );

    public static void handle(ServantBellSetPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            if (sender.field_6002.method_8469(message.id) instanceof EntityMaid maid && maid.method_6171(sender)) {
                ItemServantBell.recordMaidInfo(sender.method_6047(), maid.method_5667(), message.tip);
            }
        });
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
