package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidAISoundInstance;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record TTSAudioToClientPackage(int maidId, byte[] data) implements class_8710 {
    public static final class_8710.class_9154<TTSAudioToClientPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("tts_audio_to_client"));
    public static final class_9139<ByteBuf, TTSAudioToClientPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            TTSAudioToClientPackage::maidId,
            class_9135.field_48987,
            TTSAudioToClientPackage::data,
            TTSAudioToClientPackage::new
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(TTSAudioToClientPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> onHandle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(TTSAudioToClientPackage message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1297 entity = mc.field_1687.method_8469(message.maidId);
        if (!(entity instanceof EntityMaid maid)) {
            return;
        }
        if (maid.method_5805()) {
            MaidAISoundInstance instance = new MaidAISoundInstance(maid, message.data);
            class_310.method_1551().method_1483().method_4873(instance);
        }
    }
}
