package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8786;

public final class JERIUtil {
    public static void recipeWarpHolder(List<class_8786<AltarRecipe>> altarRecipes, AltarRecipeMaker maker) {
        for (class_8786<AltarRecipe> altarRecipeHolder : altarRecipes) {
            AltarRecipe altarRecipe = altarRecipeHolder.comp_1933();
            recipeMaker(maker, altarRecipe);
        }
    }

    public static void recipeWarp(List<AltarRecipe> altarRecipes, AltarRecipeMaker maker) {
        for (AltarRecipe altarRecipeHolder : altarRecipes) {
            recipeMaker(maker, altarRecipeHolder);
        }
    }

    private static void recipeMaker(AltarRecipeMaker maker, AltarRecipe altarRecipe) {
        class_310.method_1551().field_1687.method_8433().method_30027(InitRecipes.ALTAR_CRAFTING);
        class_2960 recipeId = altarRecipe.getId();
        class_1799 output = altarRecipe.method_8110(class_310.method_1551().field_1687.method_30349());
        if (!altarRecipe.isItemCraft()) {
            output = InitItems.ENTITY_PLACEHOLDER.method_7854();
            ItemEntityPlaceholder.setRecipeId(output, altarRecipe.getRecipeString());
        }
        maker.accept(recipeId, altarRecipe.method_8117(), output, altarRecipe.getPower(), altarRecipe.getLangKey());
    }

    public interface AltarRecipeMaker {
        void accept(class_2960 recipeId, class_2371<class_1856> inputs, class_1799 output, float powerCost, String langKey);
    }
}