package com.github.tartaricacid.touhoulittlemaid.util;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

import static net.minecraft.class_2960.method_20209;
import static net.minecraft.class_2960.method_20208;

public class ResourceLocationUtil {
    public static boolean isValidResourceLocation(String pLocation) {
        String[] astring = decompose(pLocation, ':');
        return method_20209(StringUtils.isEmpty(astring[0]) ? "minecraft" : astring[0]) && method_20208(astring[1]);
    }

    @SuppressWarnings("SameParameterValue")
    protected static String[] decompose(String pLocation, char pSeparator) {
        String[] astring = new String[]{"minecraft", pLocation};
        int i = pLocation.indexOf(pSeparator);
        if (i >= 0) {
            astring[1] = pLocation.substring(i + 1);
            if (i >= 1) {
                astring[0] = pLocation.substring(0, i);
            }
        }

        return astring;
    }

    public static class_2960 getResourceLocation(String pLocation) {
        return class_2960.method_60655(TouhouLittleMaid.MOD_ID, pLocation);
    }
}
