/*
 * Decompiled with CFR 0.152.
 */
package cn.sh1rocu.touhoulittlemaid.util.itemhandler;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.EmptyItemHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandlerModifiable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class CombinedInvWrapper
implements IItemHandlerModifiable {
    protected final IItemHandlerModifiable[] itemHandler;
    protected final int[] baseIndex;
    protected final int slotCount;

    public CombinedInvWrapper(IItemHandlerModifiable ... itemHandler) {
        this.itemHandler = itemHandler;
        this.baseIndex = new int[itemHandler.length];
        int index = 0;
        for (int i = 0; i < itemHandler.length; ++i) {
            this.baseIndex[i] = index += itemHandler[i].getSlots();
        }
        this.slotCount = index;
    }

    protected int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    protected IItemHandlerModifiable getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.itemHandler.length) {
            return (IItemHandlerModifiable)EmptyItemHandler.INSTANCE;
        }
        return this.itemHandler[index];
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        handler.setStackInSlot(slot, stack);
    }

    @Override
    public int getSlots() {
        return this.slotCount;
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        return handler.getStackInSlot(slot);
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        return handler.insertItem(slot, stack, simulate);
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(index);
        slot = this.getSlotFromIndex(slot, index);
        return handler.extractItem(slot, amount, simulate);
    }

    @Override
    public int getSlotLimit(int slot) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(index);
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.getSlotLimit(localSlot);
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        int index = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(index);
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.isItemValid(localSlot, stack);
    }

    public void readFromNbt(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        if (tag.method_10545("Inventory")) {
            this.deserializeNBT(registryLookup, tag.method_10562("Inventory"));
        }
    }

    public void writeToNbt(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        tag.method_10566("Inventory", (class_2520)this.serializeNBT(registryLookup));
    }

    public class_2487 serializeNBT(class_7225.class_7874 provider) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getStackInSlot(i).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            nbtTagList.add((Object)this.getStackInSlot(i).method_57376(provider, (class_2520)itemTag));
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.getSlots());
        return nbt;
    }

    public void deserializeNBT(class_7225.class_7874 provider, class_2487 nbt) {
        int size = nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.getSlots();
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= size) continue;
            class_1799.method_57360((class_7225.class_7874)provider, (class_2520)itemTags).ifPresent(stack -> this.setStackInSlot(slot, (class_1799)stack));
        }
    }
}

