/*
 * Decompiled with CFR 0.152.
 */
package cn.sh1rocu.touhoulittlemaid.util.itemhandler;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandlerModifiable;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.INBTSerializable;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class ItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<class_2487> {
    protected class_2371<class_1799> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public ItemStackHandler(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public void readFromNbt(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        if (tag.method_10545("Inventory")) {
            this.deserializeNBT(registryLookup, tag.method_10562("Inventory"));
        }
    }

    public void writeToNbt(@NotNull class_2487 tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registryLookup) {
        tag.method_10566("Inventory", (class_2520)this.serializeNBT(registryLookup));
    }

    public void setSize(int size) {
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        this.validateSlotIndex(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (class_1799)this.stacks.get(slot);
    }

    @Override
    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.method_7960()) {
            if (!class_1799.method_31577((class_1799)stack, (class_1799)existing)) {
                return stack;
            }
            limit -= existing.method_7947();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.method_7947() > limit;
        if (!simulate) {
            if (existing.method_7960()) {
                this.stacks.set(slot, (Object)(reachedLimit ? stack.method_46651(limit) : stack));
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? stack.method_46651(stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        this.validateSlotIndex(slot);
        class_1799 existing = (class_1799)this.stacks.get(slot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, existing.method_7914());
        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)class_1799.field_8037);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.method_7972();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)existing.method_46651(existing.method_7947() - toExtract));
            this.onContentsChanged(slot);
        }
        return existing.method_46651(toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 99;
    }

    protected int getStackLimit(int slot, class_1799 stack) {
        return Math.min(this.getSlotLimit(slot), stack.method_7914());
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        return true;
    }

    @Override
    public class_2487 serializeNBT(class_7225.class_7874 provider) {
        class_2499 nbtTagList = new class_2499();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((class_1799)this.stacks.get(i)).method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            nbtTagList.add((Object)((class_1799)this.stacks.get(i)).method_57376(provider, (class_2520)itemTag));
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("Items", (class_2520)nbtTagList);
        nbt.method_10569("Size", this.stacks.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_7225.class_7874 provider, class_2487 nbt) {
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.stacks.size());
        class_2499 tagList = nbt.method_10554("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            class_2487 itemTags = tagList.method_10602(i);
            int slot = itemTags.method_10550("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            class_1799.method_57360((class_7225.class_7874)provider, (class_2520)itemTags).ifPresent(stack -> this.stacks.set(slot, stack));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}

