/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Point;
import com.github.tartaricacid.touhoulittlemaid.api.game.gomoku.Statue;
import com.github.tartaricacid.touhoulittlemaid.block.BlockJoy;
import com.github.tartaricacid.touhoulittlemaid.block.properties.GomokuPart;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.MaidGomokuAI;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.GomokuClientPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SpawnParticlePackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityGomoku;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_702;
import net.minecraft.class_8710;
import net.minecraft.class_9062;

public class BlockGomoku
extends BlockJoy
implements IBoardGameBlock,
IBlock {
    public static final class_2754<GomokuPart> PART = class_2754.method_11850((String)"part", GomokuPart.class);
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_265 LEFT_UP = class_2248.method_9541((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    public static final class_265 LEFT_UP_WITH_BOX = class_259.method_1084((class_265)LEFT_UP, (class_265)class_2248.method_9541((double)11.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)7.0));
    public static final class_265 UP = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)2.0, (double)16.0);
    public static final class_265 RIGHT_UP = class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)16.0);
    public static final class_265 RIGHT_UP_WITH_BOX = class_259.method_1084((class_265)RIGHT_UP, (class_265)class_2248.method_9541((double)9.0, (double)0.0, (double)11.0, (double)14.0, (double)4.0, (double)16.0));
    public static final class_265 LEFT_CENTER = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final class_265 CENTER = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final class_265 RIGHT_CENTER = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)16.0);
    public static final class_265 LEFT_DOWN = class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    public static final class_265 LEFT_DOWN_WITH_BOX = class_259.method_1084((class_265)LEFT_DOWN, (class_265)class_2248.method_9541((double)2.0, (double)0.0, (double)0.0, (double)7.0, (double)4.0, (double)5.0));
    public static final class_265 DOWN = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0);
    public static final class_265 RIGHT_DOWN = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0);
    public static final class_265 RIGHT_DOWN_WITH_BOX = class_259.method_1084((class_265)RIGHT_DOWN, (class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)9.0, (double)5.0, (double)4.0, (double)14.0));

    public BlockGomoku() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9626(class_2498.field_11547).method_9629(2.0f, 3.0f).method_51369().method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)GomokuPart.CENTER))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    private static void handleGomokuRemove(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            GomokuPart part = (GomokuPart)((Object)state.method_11654(PART));
            class_2338 centerPos = pos.method_10059(new class_2382(part.getPosX(), 0, part.getPosY()));
            class_2586 te = world.method_8321(centerPos);
            BlockGomoku.method_9577((class_1937)world, (class_2338)centerPos, (class_1799)InitItems.GOMOKU.method_7854());
            if (te instanceof TileEntityGomoku) {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        world.method_8501(centerPos.method_10069(i, 0, j), class_2246.field_10124.method_9564());
                    }
                }
            }
        }
    }

    @Nullable
    private static int[] getChessPos(double x, double y, GomokuPart part) {
        switch (part) {
            case LEFT_UP: {
                return BlockGomoku.getData(x, y, 0.505, 0.505, 0.54, 0.54, 0, 0);
            }
            case UP: {
                return BlockGomoku.getData(x, y, 0.037, 0.505, 0.08, 0.54, 4, 0);
            }
            case RIGHT_UP: {
                return BlockGomoku.getData(x, y, -0.037, 0.505, -0.01, 0.54, 11, 0);
            }
            case LEFT_CENTER: {
                return BlockGomoku.getData(x, y, 0.505, 0.037, 0.54, 0.07, 0, 4);
            }
            case CENTER: {
                return BlockGomoku.getData(x, y, 0.037, 0.037, 0.08, 0.07, 4, 4);
            }
            case RIGHT_CENTER: {
                return BlockGomoku.getData(x, y, -0.037, 0.037, -0.01, 0.07, 11, 4);
            }
            case LEFT_DOWN: {
                return BlockGomoku.getData(x, y, 0.505, 0.0, 0.54, 0.0, 0, 11);
            }
            case DOWN: {
                return BlockGomoku.getData(x, y, 0.037, 0.0, 0.08, 0.0, 4, 11);
            }
            case RIGHT_DOWN: {
                return BlockGomoku.getData(x, y, -0.037, 0.0, -0.01, 0.0, 11, 11);
            }
        }
        return null;
    }

    private static boolean isClickChessBox(double x, double y, GomokuPart part, class_2350 direction) {
        if (direction.method_10166() == class_2350.class_2351.field_11051) {
            if (part == GomokuPart.RIGHT_UP) {
                return 0.5625 <= x && x <= 0.875 && 0.6875 <= y && y <= 1.0;
            }
            if (part == GomokuPart.LEFT_DOWN) {
                return 0.125 <= x && x <= 0.4375 && 0.0 <= y && y <= 0.3125;
            }
        }
        if (direction.method_10166() == class_2350.class_2351.field_11048) {
            if (part == GomokuPart.LEFT_UP) {
                return 0.6875 <= x && x <= 1.0 && 0.125 <= y && y <= 0.4375;
            }
            if (part == GomokuPart.RIGHT_DOWN) {
                return 0.0 <= x && x <= 0.3125 && 0.5625 <= y && y <= 0.875;
            }
        }
        return false;
    }

    @Nullable
    private static int[] getData(double x, double y, double xOffset, double yOffset, double xStartOffset, double yStartOffset, int xIndexOffset, int yIndexOffset) {
        boolean checkClick;
        int xIndex = (int)((x - xOffset) / 0.1316);
        int yIndex = (int)((y - yOffset) / 0.1316);
        double xStart = xStartOffset + (double)xIndex * 0.1316;
        double xEnd = xStart + 0.07;
        double yStart = yStartOffset + (double)yIndex * 0.1316;
        double yEnd = yStart + 0.07;
        boolean checkIndex = 0 <= (xIndex += xIndexOffset) && xIndex <= 14 && 0 <= (yIndex += yIndexOffset) && yIndex <= 14;
        boolean bl = checkClick = xStart < x && x < xEnd && yStart < y && y < yEnd;
        if (checkIndex && checkClick) {
            return new int[]{xIndex, yIndex};
        }
        return null;
    }

    @Override
    protected class_243 sitPosition() {
        return class_243.field_1353;
    }

    @Override
    protected String getTypeName() {
        return Type.GOMOKU.getTypeName();
    }

    @Override
    protected int sitYRot() {
        return 0;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        BlockGomoku.handleGomokuRemove(world, pos, state);
        return super.method_9576(world, pos, state, player);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        return false;
    }

    @Override
    public void onBlockExploded(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion) {
        BlockGomoku.handleGomokuRemove(world, pos, state);
        IBlock.super.onBlockExploded(state, world, pos, explosion);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 centerPos = context.method_8037();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                class_2338 searchPos = centerPos.method_10069(i, 0, j);
                if (context.method_8045().method_8320(searchPos).method_26166(context)) continue;
                return null;
            }
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (worldIn.field_9236) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                class_2338 searchPos = pos.method_10069(i, 0, j);
                GomokuPart part = GomokuPart.getPartByPos(i, j);
                if (part == null || part.isCenter()) continue;
                worldIn.method_8652(searchPos, (class_2680)state.method_11657(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    @Override
    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (hand == class_1268.field_5808 && player.method_6047().method_7960()) {
                class_1297 class_12972;
                GomokuPart part = (GomokuPart)((Object)state.method_11654(PART));
                class_2338 centerPos = pos.method_10059(new class_2382(part.getPosX(), 0, part.getPosY()));
                class_2586 te = level.method_8321(centerPos);
                if (!(te instanceof TileEntityGomoku)) {
                    return class_9062.field_47733;
                }
                TileEntityGomoku gomoku = (TileEntityGomoku)te;
                class_243 location = hit.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
                class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                if (BlockGomoku.isClickChessBox(location.field_1352, location.field_1350, part, facing)) {
                    class_1297 class_12973;
                    level.method_8396(null, centerPos, InitSounds.GOMOKU_RESET, class_3419.field_15245, 1.0f, 1.0f);
                    gomoku.reset();
                    gomoku.refresh();
                    class_1297 sitEntity = serverLevel.method_14190(gomoku.getSitId());
                    if (sitEntity != null && sitEntity.method_5805() && (class_12973 = sitEntity.method_31483()) instanceof EntityMaid) {
                        EntityMaid maid = (EntityMaid)class_12973;
                        maid.getGameRecordManager().resetStatue();
                    }
                    return class_9062.field_47728;
                }
                class_1297 sitEntity = serverLevel.method_14190(gomoku.getSitId());
                if (sitEntity == null || !sitEntity.method_5805() || !((class_12972 = sitEntity.method_31483()) instanceof EntityMaid)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.gomoku.no_maid"));
                    return class_9062.field_47733;
                }
                EntityMaid maid = (EntityMaid)class_12972;
                if (((Boolean)MaidConfig.MAID_GOMOKU_OWNER_LIMIT.get()).booleanValue() && !maid.method_6171((class_1309)player)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.gomoku.not_owner"));
                    return class_9062.field_47733;
                }
                if (!gomoku.isPlayerTurn()) {
                    return class_9062.field_47733;
                }
                byte[][] chessData = gomoku.getChessData();
                int[] clickPos = BlockGomoku.getChessPos(location.field_1352, location.field_1350, part);
                if (clickPos == null) {
                    return class_9062.field_47733;
                }
                Point playerPoint = new Point(clickPos[0], clickPos[1], 1);
                if (gomoku.isInProgress() && chessData[playerPoint.x][playerPoint.y] == 0) {
                    gomoku.setChessData(playerPoint.x, playerPoint.y, playerPoint.type);
                    Statue statue = MaidGomokuAI.getStatue(chessData, playerPoint);
                    if (statue == Statue.WIN && maid.method_6171((class_1309)player)) {
                        class_3222 serverPlayer;
                        maid.getFavorabilityManager().apply(Type.GOMOKU_WIN);
                        maid.getGameRecordManager().markStatue(false);
                        int rankBefore = MaidGomokuAI.getRank(maid);
                        maid.getGameRecordManager().increaseGomokuWinCount();
                        int rankAfter = MaidGomokuAI.getRank(maid);
                        if (rankBefore < rankAfter && player instanceof class_3222) {
                            serverPlayer = (class_3222)player;
                            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new SpawnParticlePackage(maid.method_5628(), SpawnParticlePackage.Type.RANK_UP));
                        }
                        if (player instanceof class_3222) {
                            serverPlayer = (class_3222)player;
                            InitTrigger.MAID_EVENT.trigger(serverPlayer, "win_gomoku");
                        }
                    }
                    gomoku.setInProgress(statue == Statue.IN_PROGRESS);
                    level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8f + level.field_9229.method_43057() * 0.4f);
                    if (gomoku.isInProgress() && player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        gomoku.setPlayerTurn(false);
                        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new GomokuClientPackage(centerPos, chessData, playerPoint, maid.getGameRecordManager().getGomokuWinCount()));
                    }
                    gomoku.refresh();
                    return class_9062.field_47728;
                }
            }
        }
        return class_9062.field_47732;
    }

    @Override
    public void startMaidSit(EntityMaid maid, class_2680 state, class_1937 worldIn, class_2338 pos) {
        if (worldIn instanceof class_3218) {
            class_3218 serverLevel = (class_3218)worldIn;
            class_2586 class_25862 = worldIn.method_8321(pos);
            if (class_25862 instanceof TileEntityJoy) {
                TileEntityJoy joy = (TileEntityJoy)class_25862;
                class_1297 oldSitEntity = serverLevel.method_14190(joy.getSitId());
                if (oldSitEntity != null && oldSitEntity.method_5805()) {
                    return;
                }
                class_2350 face = ((class_2350)state.method_11654((class_2769)FACING)).method_10170();
                class_243 position = new class_243(0.5 + (double)face.method_10148() * 1.5, 0.1, 0.5 + (double)face.method_10165() * 1.5);
                EntitySit newSitEntity = new EntitySit(worldIn, class_243.method_49273((class_2382)pos, (double)position.field_1352, (double)position.field_1351, (double)position.field_1350), this.getTypeName(), pos);
                newSitEntity.method_36456(face.method_10153().method_10144() + (float)this.sitYRot());
                worldIn.method_8649((class_1297)newSitEntity);
                joy.setSitId(newSitEntity.method_5667());
                joy.method_5431();
                maid.method_5804(newSitEntity);
            }
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PART, FACING});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (((GomokuPart)((Object)state.method_11654(PART))).isCenter()) {
            return new TileEntityGomoku(pos, state);
        }
        return null;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return BlockGomoku.method_54094(properties -> new BlockGomoku());
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        switch ((GomokuPart)((Object)state.method_11654(PART))) {
            case LEFT_UP: {
                if (((class_2350)state.method_11654((class_2769)FACING)).method_10166() == class_2350.class_2351.field_11048) {
                    return LEFT_UP_WITH_BOX;
                }
                return LEFT_UP;
            }
            case UP: {
                return UP;
            }
            case RIGHT_UP: {
                if (((class_2350)state.method_11654((class_2769)FACING)).method_10166() == class_2350.class_2351.field_11051) {
                    return RIGHT_UP_WITH_BOX;
                }
                return RIGHT_UP;
            }
            case LEFT_CENTER: {
                return LEFT_CENTER;
            }
            case RIGHT_CENTER: {
                return RIGHT_CENTER;
            }
            case LEFT_DOWN: {
                if (((class_2350)state.method_11654((class_2769)FACING)).method_10166() == class_2350.class_2351.field_11051) {
                    return LEFT_DOWN_WITH_BOX;
                }
                return LEFT_DOWN;
            }
            case DOWN: {
                return DOWN;
            }
            case RIGHT_DOWN: {
                if (((class_2350)state.method_11654((class_2769)FACING)).method_10166() == class_2350.class_2351.field_11048) {
                    return RIGHT_DOWN_WITH_BOX;
                }
                return RIGHT_DOWN;
            }
        }
        return CENTER;
    }
}

