/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.download;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.info.ServerCustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.util.HttpUtil;
import com.github.tartaricacid.touhoulittlemaid.util.ZipFileCheck;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import com.mojang.util.UndashedUuid;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_5250;
import net.minecraft.class_6489;
import net.minecraft.class_746;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

@Environment(value=EnvType.CLIENT)
public class InfoGetManager {
    private static final String ROOT_URL = "https://tlmdl.cfpa.team/";
    private static final String INFO_JSON_URL = "https://tlmdl.cfpa.team/info.json";
    private static final String ROOT_URL_BACKUP = "http://tlm.cfpa.team:29434/";
    private static final String INFO_JSON_URL_BACKUP = "http://tlm.cfpa.team:29434/info.json";
    private static final int INFO_MAX_FILE_SIZE = 0x100000;
    private static final int PACK_MAX_FILE_SIZE = 0x1900000;
    private static final Path ROOT_FOLDER = InfoGetManager.getRootPath();
    private static final Path INFO_JSON_FILE = ROOT_FOLDER.resolve("info.json");
    private static final Path PACK_FOLDER = ROOT_FOLDER.resolve("file");
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_ALL = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_MAID = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_CHAIR = Lists.newArrayList();
    public static List<DownloadInfo> DOWNLOAD_INFO_LIST_SOUND = Lists.newArrayList();
    public static Statue STATUE = Statue.FIRST;
    private static boolean USE_BACKUP_URL = false;

    public static Map<String, String> getDownloadHeaders() {
        HashMap map = Maps.newHashMap();
        class_320 user = class_310.method_1551().method_1548();
        class_6489 currentVersion = class_155.method_16673();
        map.put("X-Minecraft-Username", user.method_1676());
        map.put("X-Minecraft-UUID", UndashedUuid.toString((UUID)user.method_44717()));
        map.put("X-Minecraft-Version", currentVersion.method_48019());
        map.put("X-Minecraft-Version-ID", currentVersion.method_48018());
        map.put("X-Fabric-Version", ((ModContainer)FabricLoader.getInstance().getModContainer("fabric").get()).getMetadata().getVersion().getFriendlyString());
        map.put("X-TLM-Version", ((ModContainer)FabricLoader.getInstance().getModContainer("touhou_little_maid").get()).getMetadata().getVersion().getFriendlyString());
        map.put("User-Agent", "Minecraft Java/" + currentVersion.method_48019());
        return map;
    }

    public static void checkInfoJsonFile() {
        if (!ROOT_FOLDER.toFile().isDirectory()) {
            try {
                Files.createDirectories(ROOT_FOLDER, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                ioe.fillInStackTrace();
                return;
            }
        }
        File infoJsonFile = INFO_JSON_FILE.toFile();
        try {
            InfoGetManager.downloadInfoJson(infoJsonFile);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    public static String getFileMd5(File file) {
        String md5 = "";
        if (!file.isFile()) {
            return md5;
        }
        try (FileInputStream stream = new FileInputStream(file);){
            md5 = DigestUtils.md5Hex((InputStream)stream);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        return md5;
    }

    private static Path getRootPath() {
        Path configPath = null;
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null && minecraft.field_1697 != null) {
            URI gameUri = minecraft.field_1697.toURI();
            configPath = Paths.get(gameUri).resolve("config");
        } else {
            configPath = Paths.get("./", new String[0]).resolve("config");
        }
        return configPath.resolve("touhou_little_maid");
    }

    private static void downloadInfoJson(File infoJsonFile) throws IOException {
        Proxy proxy = class_310.method_1551().method_1487();
        URL infoJsonUrl = URI.create(INFO_JSON_URL).toURL();
        URL infoJsonUrlBackup = URI.create(INFO_JSON_URL_BACKUP).toURL();
        String md5Previous = InfoGetManager.getFileMd5(infoJsonFile);
        CompletableFuture<?> downloader = HttpUtil.downloadTo(infoJsonFile, infoJsonUrl, InfoGetManager.getDownloadHeaders(), 0x100000, null, proxy);
        ((CompletableFuture)((CompletableFuture)downloader.exceptionallyCompose(error -> {
            TouhouLittleMaid.LOGGER.warn("Line 1 is inaccessible, try to use line 2");
            USE_BACKUP_URL = true;
            return HttpUtil.downloadTo(infoJsonFile, infoJsonUrlBackup, InfoGetManager.getDownloadHeaders(), 0x100000, null, proxy);
        })).thenRun(() -> {
            InfoGetManager.loadInfoJson(infoJsonFile);
            TouhouLittleMaid.LOGGER.info("The download info file was successfully updated and loaded");
            String md5Current = InfoGetManager.getFileMd5(infoJsonFile);
            if (StringUtils.isBlank((CharSequence)md5Previous) || StringUtils.isBlank((CharSequence)md5Current)) {
                return;
            }
            STATUE = md5Previous.equals(md5Current) ? Statue.NOT_UPDATE : Statue.UPDATE;
        })).exceptionally(error -> {
            TouhouLittleMaid.LOGGER.warn("Failed to download info file, possibly due to network issues");
            return null;
        });
    }

    private static void loadInfoJson(File infoJsonFile) {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(infoJsonFile), StandardCharsets.UTF_8);){
            DOWNLOAD_INFO_LIST_ALL = (List)CustomPackLoader.GSON.fromJson((Reader)reader, new TypeToken<List<DownloadInfo>>(){}.getType());
            DOWNLOAD_INFO_LIST_ALL.forEach(DownloadInfo::decorate);
            DOWNLOAD_INFO_LIST_ALL.forEach(downloadInfo -> {
                if (downloadInfo.hasType(DownloadInfo.TypeEnum.MAID)) {
                    DOWNLOAD_INFO_LIST_MAID.add((DownloadInfo)downloadInfo);
                }
                if (downloadInfo.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                    DOWNLOAD_INFO_LIST_CHAIR.add((DownloadInfo)downloadInfo);
                }
                if (downloadInfo.hasType(DownloadInfo.TypeEnum.SOUND)) {
                    DOWNLOAD_INFO_LIST_SOUND.add((DownloadInfo)downloadInfo);
                }
            });
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void onClientSetup() {
        InfoGetManager.checkInfoJsonFile();
    }

    public static void downloadPack(DownloadInfo info) {
        try {
            Proxy proxy = class_310.method_1551().method_1487();
            info.setStatus(DownloadStatus.DOWNLOADING);
            String rootUrl = USE_BACKUP_URL ? ROOT_URL_BACKUP : ROOT_URL;
            URL url = URI.create(rootUrl).resolve(info.getUrl()).toURL();
            File fileInTlmModel = CustomPackLoader.PACK_FOLDER.resolve(info.getFileName()).toFile();
            File fileInCache = PACK_FOLDER.resolve(info.getFileName()).toFile();
            if (!fileInCache.isFile() || FileUtils.checksumCRC32((File)fileInCache) != info.getChecksum()) {
                InfoGetManager.downloadPack(info, fileInCache, url, proxy, fileInTlmModel);
            } else {
                InfoGetManager.reloadPack(info, fileInCache, fileInTlmModel);
                InfoGetManager.sendDownloadMessage(class_2561.method_43469((String)"gui.touhou_little_maid.resources_download.state.downloaded", (Object[])new Object[]{info.getFileName(), 0.943}));
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
    }

    private static void downloadPack(DownloadInfo info, File fileInCache, URL url, Proxy proxy, File fileInTlmModel) {
        InfoGetManager.sendDownloadMessage(class_2561.method_43469((String)"gui.touhou_little_maid.resources_download.state.downloading", (Object[])new Object[]{info.getFileName()}));
        StopWatch stopWatch = StopWatch.createStarted();
        CompletableFuture<?> downloader = HttpUtil.downloadTo(fileInCache, url, InfoGetManager.getDownloadHeaders(), 0x1900000, info, proxy);
        ((CompletableFuture)downloader.thenRun(() -> {
            stopWatch.stop();
            InfoGetManager.sendDownloadMessage(class_2561.method_43469((String)"gui.touhou_little_maid.resources_download.state.downloaded", (Object[])new Object[]{info.getFileName(), (double)stopWatch.getTime(TimeUnit.MILLISECONDS) / 1000.0}));
            try {
                InfoGetManager.reloadPack(info, fileInCache, fileInTlmModel);
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        })).exceptionally(error -> {
            stopWatch.stop();
            info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            TouhouLittleMaid.LOGGER.warn("Failed to download pack file, possibly due to network issues");
            return null;
        });
    }

    private static void reloadPack(DownloadInfo info, File fileInCache, File fileInTlmModel) throws IOException {
        if (ZipFileCheck.isZipFile(fileInCache)) {
            Files.copy(fileInCache.toPath(), fileInTlmModel.toPath(), StandardCopyOption.REPLACE_EXISTING);
            CustomPackLoader.readModelFromZipFile(fileInTlmModel);
            ServerCustomPackLoader.reloadPacks();
            info.setStatus(DownloadStatus.DOWNLOADED);
        } else {
            info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            TouhouLittleMaid.LOGGER.error("{} file is corrupt and cannot be loaded.", (Object)info.getFileName());
        }
    }

    public static void sendDownloadMessage(class_5250 component) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_43496((class_2561)component);
        }
    }

    public static List<DownloadInfo> getTypedDownloadInfoList(DownloadInfo.TypeEnum typeEnum) {
        return switch (typeEnum) {
            case DownloadInfo.TypeEnum.CHAIR -> DOWNLOAD_INFO_LIST_CHAIR;
            case DownloadInfo.TypeEnum.SOUND -> DOWNLOAD_INFO_LIST_SOUND;
            default -> DOWNLOAD_INFO_LIST_MAID;
        };
    }

    public static int getPackMaxFileSize() {
        return 0x1900000;
    }

    public static Path getPackFolder() {
        return PACK_FOLDER;
    }

    public static enum Statue {
        FIRST,
        UPDATE,
        NOT_UPDATE;

    }
}

