/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.client.download.InfoGetManager;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.GuiDownloadButton;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.PackInfoButton;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiPackage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_407;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ModelDownloadGui
extends class_437 {
    private static final class_2960 BG = class_2960.method_60655((String)"touhou_little_maid", (String)"textures/gui/download_background.png");
    private static final String PACK_FILE_SUFFIX = ".zip";
    private final Map<Long, String> crc32Infos = Maps.newHashMap();
    private final List<DownloadInfo> showInfos = Lists.newArrayList();
    private final EntityMaid maid;
    private Condition condition = Condition.ALL;
    private class_342 textField;
    private boolean needReload = false;
    private int selectIndex = -1;
    private int currentPage;
    private int x;
    private int y;

    public ModelDownloadGui(EntityMaid maid) {
        super((class_2561)class_2561.method_43470((String)"New Model Pack Download GUI"));
        this.getCrc32Infos();
        this.checkDownloadInfo();
        this.maid = maid;
    }

    protected void method_25426() {
        this.method_37067();
        this.x = (this.field_22789 - 420) / 2;
        this.y = (this.field_22790 - 240) / 2;
        this.initShowInfos();
        this.addBaseButtons();
        this.addPackButtons();
        this.addPageButtons();
        this.addPackHandleButtons();
        this.addSearchBox();
    }

    private void addSearchBox() {
        String textCache = this.textField == null ? "" : this.textField.method_1882();
        boolean focus = this.textField != null && this.textField.method_25370();
        this.textField = new class_342(Screens.getTextRenderer((class_437)this), this.x + 273, this.y + 78, 144, 16, (class_2561)class_2561.method_43473());
        this.textField.method_1868(15986656);
        this.textField.method_25365(focus);
        this.textField.method_1852(textCache);
        this.textField.method_1872(class_437.method_25442());
        this.method_25429((class_364)this.textField);
    }

    private void addPackHandleButtons() {
        if (0 <= this.selectIndex && this.selectIndex < this.showInfos.size()) {
            DownloadInfo info = this.showInfos.get(this.selectIndex);
            this.method_37063((class_364)new FlatColorButton(this.x + 272, this.y + 50, 20, 20, (class_2561)class_2561.method_43473(), b -> this.openPackWebsite(info)).setTooltips("gui.touhou_little_maid.resources_download.open_link"));
            this.method_37063((class_364)new GuiDownloadButton(this.x + 294, this.y + 50, 102, 20, info, b -> {
                if (info.getStatus() == DownloadStatus.NOT_DOWNLOAD) {
                    info.setStatus(DownloadStatus.DOWNLOADING);
                    InfoGetManager.downloadPack(info);
                    this.method_25426();
                } else if (info.getStatus() == DownloadStatus.NEED_UPDATE) {
                    this.updatePack(info);
                }
            }));
            this.method_37063((class_364)new FlatColorButton(this.x + 398, this.y + 50, 20, 20, (class_2561)class_2561.method_43473(), b -> this.deletePack(info)).setTooltips("gui.touhou_little_maid.resources_download.delete"));
        }
    }

    private void addPageButtons() {
        this.method_37063((class_364)new FlatColorButton(this.x, this.y + 218, 40, 20, (class_2561)class_2561.method_43470((String)"<"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.method_25426();
            }
        }));
        this.method_37063((class_364)new FlatColorButton(this.x + 228, this.y + 218, 40, 20, (class_2561)class_2561.method_43470((String)">"), b -> {
            if (this.currentPage * 4 + 4 <= this.showInfos.size()) {
                ++this.currentPage;
                this.method_25426();
            }
        }));
    }

    private void addPackButtons() {
        int startIndex;
        for (int i = startIndex = this.currentPage * 4; i < startIndex + 4 && i < this.showInfos.size(); ++i) {
            DownloadInfo info = this.showInfos.get(i);
            int yOffset = this.y + 26 + (i - startIndex) * 48;
            int tmp = i;
            PackInfoButton button = new PackInfoButton(this.x, yOffset, info, b -> {
                this.selectIndex = tmp;
                this.method_25426();
            });
            if (this.selectIndex == i) {
                button.setSelect(true);
            }
            this.method_37063((class_364)button);
        }
    }

    private void addBaseButtons() {
        int i = 0;
        for (Condition c : Condition.values()) {
            int width = 52;
            int xPos = this.x + (width + 2) * i;
            String key = c.name().toLowerCase(Locale.US);
            String nameKey = "gui.touhou_little_maid.resources_download." + key;
            String descKey = nameKey + ".tips";
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43471((String)nameKey), b -> this.setCondition(c)).method_46437(width, 20).method_46433(xPos, this.y + 3).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)descKey))).method_46431();
            if (this.condition.equals((Object)c)) {
                button.field_22763 = false;
            }
            this.method_37063((class_364)button);
            ++i;
        }
        this.method_37063((class_364)new FlatColorButton(this.x + 400, this.y + 2, 20, 20, (class_2561)class_2561.method_43473(), b -> {
            if (this.maid != null) {
                ClientPlayNetworking.send((class_8710)new OpenMaidGuiPackage(this.maid.method_5628()));
            }
        }).setTooltips("gui.touhou_little_maid.skin.button.close"));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.open_folder"), b -> class_156.method_668().method_672(CustomPackLoader.PACK_FOLDER.toFile())).method_46433(this.x + 270, this.y + 218).method_46437(150, 20).method_46431());
    }

    private void initShowInfos() {
        this.showInfos.clear();
        switch (this.condition.ordinal()) {
            case 1: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.MAID));
                break;
            }
            case 2: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.CHAIR));
                break;
            }
            case 3: {
                this.showInfos.addAll(InfoGetManager.getTypedDownloadInfoList(DownloadInfo.TypeEnum.SOUND));
                break;
            }
            case 4: {
                this.showInfos.addAll(InfoGetManager.DOWNLOAD_INFO_LIST_ALL.stream().filter(info -> info.getStatus() == DownloadStatus.NEED_UPDATE).toList());
                break;
            }
            default: {
                this.showInfos.addAll(InfoGetManager.DOWNLOAD_INFO_LIST_ALL);
            }
        }
        if (this.textField != null && StringUtils.isNotBlank((CharSequence)this.textField.method_1882())) {
            String search = this.textField.method_1882().toLowerCase(Locale.US);
            this.showInfos.removeIf(info -> !info.getKeyword().contains(search));
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float pPartialTick) {
        super.method_57734(pPartialTick);
        this.renderBase(graphics);
        this.renderSearchBox(graphics, mouseX, mouseY, pPartialTick);
        this.renderPageNumber(graphics);
        for (class_4068 renderable : ((ScreenAccessor)((Object)this)).tlm$getRenderables()) {
            renderable.method_25394(graphics, mouseX, mouseY, pPartialTick);
        }
        this.renderBaseButtons(graphics);
        this.renderPackHandleButtons(graphics);
        this.renderNoDataTips(graphics);
        ((ScreenAccessor)((Object)this)).tlm$getRenderables().stream().filter(b -> b instanceof FlatColorButton).forEach(b -> ((FlatColorButton)((Object)b)).renderToolTip(graphics, this, mouseX, mouseY));
    }

    private void renderNoDataTips(class_332 graphics) {
        if (!InfoGetManager.DOWNLOAD_INFO_LIST_ALL.isEmpty()) {
            return;
        }
        List split = this.field_22793.method_1728((class_5348)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.fail"), 200);
        int yOffset = this.y + 100;
        for (class_5481 sequence : split) {
            graphics.method_35719(this.field_22793, sequence, this.x + 134, yOffset, class_124.field_1061.method_532().intValue());
            yOffset += 12;
        }
    }

    private void renderPageNumber(class_332 graphics) {
        int maxPage = (this.showInfos.size() - 1) / 4;
        String pageInfo = String.format("%d/%d", this.currentPage + 1, maxPage + 1);
        int n = this.x + 134 - this.field_22793.method_1727(pageInfo) / 2;
        Objects.requireNonNull(this.field_22793);
        graphics.method_25303(this.field_22793, pageInfo, n, this.y + 227 - 9 / 2, 15986656);
    }

    private void renderPackHandleButtons(class_332 graphics) {
        if (0 <= this.selectIndex && this.selectIndex < this.showInfos.size()) {
            DownloadInfo info = this.showInfos.get(this.selectIndex);
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)info.getName()), this.x + 345, this.y + 34, 0xFFFFFF);
            graphics.method_25302(BG, this.x + 400, this.y + 52, 0, 16, 16, 16);
            graphics.method_25302(BG, this.x + 274, this.y + 52, 16, 16, 16, 16);
        }
    }

    private void renderBaseButtons(class_332 graphics) {
        graphics.method_25302(BG, this.x + 402, this.y + 4, 32, 16, 16, 16);
    }

    private void renderSearchBox(class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.hot_search"), this.x + 274, this.y + 102, 0xFFFFFF);
        graphics.method_51440(this.field_22793, (class_5348)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.hot_search_key"), this.x + 274, this.y + 115, 146, class_124.field_1080.method_532().intValue());
        this.textField.method_25394(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.textField.method_1882().isEmpty() && !this.textField.method_25370()) {
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.search").method_27692(class_124.field_1056), this.x + 277, this.y + 83, 0x777777);
        }
    }

    private void renderBase(class_332 graphics) {
        graphics.method_25296(0, 0, this.field_22789, this.field_22790, -503316480, -503316480);
        graphics.method_25296(this.x + 270, this.y + 26, this.x + 420, this.y + 72, -14474719, -14474719);
        graphics.method_25296(this.x + 270, this.y + 74, this.x + 420, this.y + 216, -14474719, -14474719);
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String value = this.textField.method_1882();
        super.method_25410(minecraft, width, height);
        this.textField.method_1852(value);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.textField.method_25402(mouseX, mouseY, button)) {
            this.method_25395((class_364)this.textField);
            return true;
        }
        if (this.textField.method_25370()) {
            this.textField.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.textField == null) {
            return false;
        }
        String perText = this.textField.method_1882();
        if (this.textField.method_25400(codePoint, modifiers)) {
            if (!Objects.equals(perText, this.textField.method_1882())) {
                this.currentPage = 0;
                this.method_25426();
            }
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean hasKeyCode = class_3675.method_15985((int)keyCode, (int)scanCode).method_30103().isPresent();
        String preText = this.textField.method_1882();
        if (hasKeyCode) {
            return true;
        }
        if (this.textField.method_25404(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(preText, this.textField.method_1882())) {
                this.currentPage = 0;
                this.method_25426();
            }
            return true;
        }
        return this.textField.method_25370() && this.textField.method_1885() && keyCode != 256 || super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25415(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.method_1852(text);
        } else {
            this.textField.method_1867(text);
        }
    }

    public void method_25419() {
        if (this.needReload && Screens.getClient((class_437)this).field_1724 != null) {
            Screens.getClient((class_437)this).field_1705.method_34004((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.need_reload.title"));
            Screens.getClient((class_437)this).field_1705.method_34002((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.need_reload.subtitle"));
            Screens.getClient((class_437)this).field_1724.method_43496((class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.need_reload.subtitle"));
        }
        super.method_25419();
    }

    private void getCrc32Infos() {
        this.crc32Infos.clear();
        try {
            Files.walkFileTree(CustomPackLoader.PACK_FOLDER, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(ModelDownloadGui.PACK_FILE_SUFFIX)) {
                        ModelDownloadGui.this.crc32Infos.put(FileUtils.checksumCRC32((File)file.toFile()), file.toFile().getName());
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkDownloadInfo() {
        block0: for (DownloadInfo info : InfoGetManager.DOWNLOAD_INFO_LIST_ALL) {
            if (info.getStatus() != DownloadStatus.DOWNLOADING) {
                info.setStatus(DownloadStatus.NOT_DOWNLOAD);
            }
            for (Long crc32 : this.crc32Infos.keySet()) {
                if (crc32.equals(info.getChecksum())) {
                    info.setStatus(DownloadStatus.DOWNLOADED);
                    continue block0;
                }
                if (!info.getOldVersion().contains(crc32)) continue;
                info.setStatus(DownloadStatus.NEED_UPDATE);
                continue block0;
            }
        }
    }

    private void setCondition(Condition condition) {
        if (this.condition != condition) {
            this.condition = condition;
            this.currentPage = 0;
            this.method_25426();
        }
    }

    private void openPackWebsite(DownloadInfo info) {
        String website = info.getWebsite();
        if (StringUtils.isNotBlank((CharSequence)website)) {
            Screens.getClient((class_437)this).method_1507((class_437)new class_407(yes -> {
                if (yes) {
                    class_156.method_668().method_670(website);
                }
                Screens.getClient((class_437)this).method_1507((class_437)this);
            }, website, false));
        }
    }

    private void deletePack(DownloadInfo info) {
        Set<String> deleteFiles = this.getDeleteFiles(info);
        if (info.getStatus() == DownloadStatus.DOWNLOADED || info.getStatus() == DownloadStatus.NEED_UPDATE) {
            Screens.getClient((class_437)this).method_1507((class_437)new class_410(yes -> this.deleteFilesAndReload(yes, deleteFiles), (class_2561)class_2561.method_43471((String)"gui.touhou_little_maid.resources_download.delete.confirm"), (class_2561)class_2561.method_43471((String)info.getName())));
        }
    }

    private void updatePack(DownloadInfo info) {
        Set<String> deleteFiles = this.getDeleteFiles(info);
        this.deleteFiles(deleteFiles);
        info.setStatus(DownloadStatus.DOWNLOADING);
        InfoGetManager.downloadPack(info);
        this.needReload = true;
        this.getCrc32Infos();
        this.checkDownloadInfo();
        this.method_25426();
    }

    @NotNull
    private Set<String> getDeleteFiles(DownloadInfo info) {
        HashSet deleteFiles = Sets.newHashSet();
        deleteFiles.add(info.getFileName());
        info.getOldVersion().forEach(version -> {
            if (this.crc32Infos.containsKey(version)) {
                deleteFiles.add(this.crc32Infos.get(version));
            }
        });
        return deleteFiles;
    }

    private void deleteFiles(Set<String> deleteFiles) {
        for (String fileName : deleteFiles) {
            try {
                Path file = CustomPackLoader.PACK_FOLDER.resolve(fileName);
                if (!Files.isRegularFile(file, new LinkOption[0])) continue;
                Files.delete(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteFilesAndReload(boolean yes, Set<String> deleteFiles) {
        if (yes) {
            this.deleteFiles(deleteFiles);
            this.needReload = true;
            this.getCrc32Infos();
            this.checkDownloadInfo();
            this.method_25426();
        }
        Screens.getClient((class_437)this).method_1507((class_437)this);
    }

    public static enum Condition {
        ALL,
        MAID,
        CHAIR,
        SOUND,
        UPDATE;

    }
}

