/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.Role;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.HistoryChatWidget;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.ClearMaidAIDataPacket;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenMaidGuiPackage;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1068;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class HistoryAIChatScreen
extends class_437 {
    private final EntityMaid maid;
    private final class_2960 playerSkin;
    private final List<LLMMessage> history = Lists.newArrayList();
    private final List<class_4068> historyWidgets = Lists.newArrayList();
    private double scroll = 0.0;
    private int maxHeight = 0;
    private int posX = 0;

    public HistoryAIChatScreen(EntityMaid maid) {
        super((class_2561)class_2561.method_43470((String)"Maid History AI Chat Screen"));
        this.maid = maid;
        this.playerSkin = this.getPlayerSkin();
        this.transformMessage();
    }

    protected void method_25426() {
        this.method_37067();
        this.historyWidgets.clear();
        this.posX = this.field_22789 / 2 - 75;
        this.maxHeight = 10;
        for (LLMMessage message : this.history) {
            int lineHeight = this.addHistoryWidget(message, this.posX);
            this.maxHeight += lineHeight + 5;
        }
        this.addButtons();
        if (this.maxHeight < this.field_22790) {
            this.scroll = (double)(this.field_22790 - this.maxHeight) / 2.0;
        } else {
            double topMax = (double)this.field_22790 / 2.0 - 100.0;
            double bottomMax = (double)this.field_22790 / 2.0 + 100.0;
            double scrollBottom = this.scroll + (double)this.maxHeight;
            if (this.scroll > topMax) {
                this.scroll = topMax;
            }
            if (bottomMax > scrollBottom) {
                this.scroll = bottomMax - (double)this.maxHeight;
            }
        }
    }

    private void addButtons() {
        class_5250 clearName = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.clear_history_chat");
        class_5250 clearMsg = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.clear_history_chat.confirm");
        this.method_37063((class_364)class_4185.method_46430((class_2561)clearName, button -> Screens.getClient((class_437)this).method_1507((class_437)new class_410(yes -> {
            if (yes) {
                this.history.clear();
                this.historyWidgets.clear();
                this.maid.getAiChatManager().getHistory().getDeque().clear();
                ClientPlayNetworking.send((class_8710)new ClearMaidAIDataPacket(this.maid.method_5628()));
            }
            Screens.getClient((class_437)this).method_1507((class_437)this);
        }, (class_2561)clearName, (class_2561)clearMsg))).method_46434(this.posX + 150, this.field_22790 / 2 - 20, 120, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> {
            OpenMaidGuiPackage message = new OpenMaidGuiPackage(this.maid.method_5628(), 3);
            ClientPlayNetworking.send((class_8710)message);
        }).method_46434(this.posX + 150, this.field_22790 / 2 + 5, 120, 20).method_46431());
    }

    private int addHistoryWidget(LLMMessage message, int posX) {
        boolean isLeft = message.role() != Role.USER;
        class_5250 msg = class_2561.method_43470((String)message.message());
        int width = Math.min(this.field_22793.method_27525((class_5348)msg), 140) + 10;
        int n = this.field_22793.method_1728((class_5348)msg, 140).size();
        Objects.requireNonNull(this.field_22793);
        int lineHeight = 10 + n * 9;
        if (isLeft) {
            this.historyWidgets.add((class_4068)new HistoryChatWidget(posX - 100, this.maxHeight, width, lineHeight, (class_2561)msg, this.playerSkin, message.gameTime(), true));
        } else {
            this.historyWidgets.add((class_4068)new HistoryChatWidget(posX + 100 - width, this.maxHeight, width, lineHeight, (class_2561)msg, this.playerSkin, message.gameTime(), false));
        }
        return lineHeight;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        class_5250 title = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat.title");
        graphics.method_27534(this.field_22793, (class_2561)title, this.posX + 210, this.field_22790 / 2 - 35, 0xFFFFFF);
        if (this.historyWidgets.isEmpty()) {
            class_5250 empty = class_2561.method_43471((String)"gui.touhou_little_maid.button.maid_ai_chat_config.history_chat_is_empty");
            List split = this.field_22793.method_1728((class_5348)empty, 150);
            for (int i = 0; i < split.size(); ++i) {
                Objects.requireNonNull(this.field_22793);
                int height = i * 9;
                graphics.method_35719(this.field_22793, (class_5481)split.get(i), this.posX, this.field_22790 / 2 - 10 + height, 0xFF5555);
            }
        } else {
            graphics.method_44379(this.posX - 128, 5, this.posX + 128, this.field_22790 - 5);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22904(0.0, this.scroll, 0.0);
            for (class_4068 renderable : this.historyWidgets) {
                renderable.method_25394(graphics, mouseX, mouseY, partialTicks);
            }
            graphics.method_51448().method_22909();
            graphics.method_44380();
        }
    }

    public boolean method_25401(double pMouseX, double pMouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0) {
            double topMax = (double)this.field_22790 / 2.0 - 100.0;
            double bottomMax = (double)this.field_22790 / 2.0 + 100.0;
            double scrollBottom = this.scroll + (double)this.maxHeight;
            if (scrollY < 0.0 && bottomMax < scrollBottom) {
                this.scroll += scrollY * 15.0;
            }
            if (0.0 < scrollY && this.scroll < topMax) {
                this.scroll += scrollY * 15.0;
            }
        }
        return super.method_25401(pMouseX, pMouseY, scrollX, scrollY);
    }

    public boolean method_25421() {
        return false;
    }

    private void transformMessage() {
        LinkedBlockingDeque<LLMMessage> deque = this.maid.getAiChatManager().getHistory().getDeque();
        deque.descendingIterator().forEachRemaining(message -> {
            if (message.role() == Role.USER) {
                this.history.add((LLMMessage)message);
            } else if (message.role() == Role.ASSISTANT && StringUtils.isNotBlank((CharSequence)message.message())) {
                ResponseChat responseChat = new ResponseChat(message.message());
                this.history.add(new LLMMessage(Role.ASSISTANT, responseChat.getChatText(), message.gameTime(), null, null));
            }
        });
    }

    private class_2960 getPlayerSkin() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return class_1068.method_4649();
        }
        return mc.method_1582().method_52862(player.method_7334()).comp_1626();
    }
}

