/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntIterator;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import net.minecraft.class_7836;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class EntityGraphics {
    private final class_4597 bufferSource;
    private final class_4587 pose;
    private final EntityMaid maid;
    private final int packedLight;
    private final float partialTicks;

    public EntityGraphics(class_4597 bufferSource, class_4587 pose, EntityMaid maid, int packedLight, float partialTicks) {
        this.bufferSource = bufferSource;
        this.pose = pose;
        this.maid = maid;
        this.packedLight = packedLight;
        this.partialTicks = partialTicks;
    }

    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.fill(minX, minY, maxX, maxY, 0, color);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int z, int color) {
        this.fill(class_1921.method_49045(), minX, minY, maxX, maxY, z, color);
    }

    public void fill(class_1921 renderType, int minX, int minY, int maxX, int maxY, int color) {
        this.fill(renderType, minX, minY, maxX, maxY, 0, color);
    }

    public void fill(class_1921 renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        Matrix4f matrix4f = this.pose.method_23760().method_23761();
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        class_4588 vertexconsumer = this.bufferSource.getBuffer(renderType);
        vertexconsumer.method_22918(matrix4f, (float)minX, (float)minY, (float)z).method_39415(color).method_60803(this.packedLight);
        vertexconsumer.method_22918(matrix4f, (float)minX, (float)maxY, (float)z).method_39415(color).method_60803(this.packedLight);
        vertexconsumer.method_22918(matrix4f, (float)maxX, (float)maxY, (float)z).method_39415(color).method_60803(this.packedLight);
        vertexconsumer.method_22918(matrix4f, (float)maxX, (float)minY, (float)z).method_39415(color).method_60803(this.packedLight);
    }

    public int drawString(class_327 font, class_5481 text, int x, int y, int color) {
        return this.drawString(font, text, (float)x, (float)y, color, true);
    }

    public int drawString(class_327 font, class_5481 text, float x, float y, int color, boolean dropShadow) {
        return font.method_22942(text, x, y, color, dropShadow, this.pose.method_23760().method_23761(), this.bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    public int drawString(class_327 font, class_2561 text, int x, int y, int color, boolean dropShadow) {
        return this.drawString(font, text.method_30937(), (float)x, (float)y, color, dropShadow);
    }

    public void drawWordWrap(class_327 font, class_5348 text, int startX, int startY, int lineWidth, int color) {
        int currentY = startY;
        for (class_5481 lineSequence : font.method_1728(text, lineWidth)) {
            this.drawString(font, lineSequence, (float)startX, (float)currentY, color, false);
            currentY += 9;
        }
    }

    public void blitNineSliced(class_2960 atlasLocation, int x, int y, int width, int height, int sliceSize, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        this.blitNineSliced(atlasLocation, x, y, width, height, sliceSize, sliceSize, sliceSize, sliceSize, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blitNineSliced(class_2960 atlasLocation, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int textureX, int textureY) {
        this.blitNineSliced(atlasLocation, x, y, width, height, sliceWidth, sliceHeight, sliceWidth, sliceHeight, uWidth, vHeight, textureX, textureY);
    }

    public void blitNineSliced(class_2960 atlasLocation, int x, int y, int width, int height, int leftSliceWidth, int topSliceHeight, int rightSliceWidth, int bottomSliceHeight, int uWidth, int vHeight, int textureX, int textureY) {
        leftSliceWidth = Math.min(leftSliceWidth, width / 2);
        rightSliceWidth = Math.min(rightSliceWidth, width / 2);
        topSliceHeight = Math.min(topSliceHeight, height / 2);
        bottomSliceHeight = Math.min(bottomSliceHeight, height / 2);
        if (width == uWidth && height == vHeight) {
            this.blit(atlasLocation, x, y, textureX, textureY, width, height);
        } else if (height == vHeight) {
            this.blit(atlasLocation, x, y, textureX, textureY, leftSliceWidth, height);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, height, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, vHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y, textureX + uWidth - rightSliceWidth, textureY, rightSliceWidth, height);
        } else if (width == uWidth) {
            this.blit(atlasLocation, x, y, textureX, textureY, width, topSliceHeight);
            this.blitRepeating(atlasLocation, x, y + topSliceHeight, width, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, uWidth, vHeight - bottomSliceHeight - topSliceHeight);
            this.blit(atlasLocation, x, y + height - bottomSliceHeight, textureX, textureY + vHeight - bottomSliceHeight, width, bottomSliceHeight);
        } else {
            this.blit(atlasLocation, x, y, textureX, textureY, leftSliceWidth, topSliceHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y, width - rightSliceWidth - leftSliceWidth, topSliceHeight, textureX + leftSliceWidth, textureY, uWidth - rightSliceWidth - leftSliceWidth, topSliceHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y, textureX + uWidth - rightSliceWidth, textureY, rightSliceWidth, topSliceHeight);
            this.blit(atlasLocation, x, y + height - bottomSliceHeight, textureX, textureY + vHeight - bottomSliceHeight, leftSliceWidth, bottomSliceHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y + height - bottomSliceHeight, width - rightSliceWidth - leftSliceWidth, bottomSliceHeight, textureX + leftSliceWidth, textureY + vHeight - bottomSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, bottomSliceHeight);
            this.blit(atlasLocation, x + width - rightSliceWidth, y + height - bottomSliceHeight, textureX + uWidth - rightSliceWidth, textureY + vHeight - bottomSliceHeight, rightSliceWidth, bottomSliceHeight);
            this.blitRepeating(atlasLocation, x, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX, textureY + topSliceHeight, leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
            this.blitRepeating(atlasLocation, x + leftSliceWidth, y + topSliceHeight, width - rightSliceWidth - leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + leftSliceWidth, textureY + topSliceHeight, uWidth - rightSliceWidth - leftSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
            this.blitRepeating(atlasLocation, x + width - rightSliceWidth, y + topSliceHeight, leftSliceWidth, height - bottomSliceHeight - topSliceHeight, textureX + uWidth - rightSliceWidth, textureY + topSliceHeight, rightSliceWidth, vHeight - bottomSliceHeight - topSliceHeight);
        }
    }

    public void blitRepeating(class_2960 atlas, int startX, int startY, int areaWidth, int areaHeight, int uOffset, int vOffset, int sourceWidth, int sourceHeight) {
        this.blitRepeating(atlas, startX, startY, areaWidth, areaHeight, uOffset, vOffset, sourceWidth, sourceHeight, 256, 256);
    }

    public void blitRepeating(class_2960 atlas, int startX, int startY, int areaWidth, int areaHeight, int uOffset, int vOffset, int sourceWidth, int sourceHeight, int textureWidth, int textureHeight) {
        int currentX = startX;
        IntIterator widthIterator = EntityGraphics.slices(areaWidth, sourceWidth);
        while (widthIterator.hasNext()) {
            int sliceWidth = widthIterator.nextInt();
            int uPadding = (sourceWidth - sliceWidth) / 2;
            int currentY = startY;
            IntIterator heightIterator = EntityGraphics.slices(areaHeight, sourceHeight);
            while (heightIterator.hasNext()) {
                int sliceHeight = heightIterator.nextInt();
                int vPadding = (sourceHeight - sliceHeight) / 2;
                this.blit(atlas, currentX, currentY, uOffset + uPadding, vOffset + vPadding, sliceWidth, sliceHeight, textureWidth, textureHeight);
                currentY += sliceHeight;
            }
            currentX += sliceWidth;
        }
    }

    private static IntIterator slices(int totalLength, int sliceLength) {
        int count = class_3532.method_38788((int)totalLength, (int)sliceLength);
        return new class_7836(totalLength, count);
    }

    public void blit(class_2960 atlasLocation, int x, int y, int uOffset, int vOffset, int uWidth, int vHeight) {
        this.blit(atlasLocation, x, y, 0, uOffset, vOffset, uWidth, vHeight, 256, 256);
    }

    public void blit(class_2960 atlasLocation, int x, int y, int blitOffset, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, x + uWidth, y, y + vHeight, blitOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public void blit(class_2960 atlasLocation, int x, int y, float uOffset, float vOffset, int width, int height, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, y, width, height, uOffset, vOffset, width, height, textureWidth, textureHeight);
    }

    public void blit(class_2960 atlasLocation, int x, int y, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        this.blit(atlasLocation, x, x + width, y, y + height, 0, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    void blit(class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        this.innerBlit(atlasLocation, x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / (float)textureWidth, (uOffset + (float)uWidth) / (float)textureWidth, (vOffset + 0.0f) / (float)textureHeight, (vOffset + (float)vHeight) / (float)textureHeight);
    }

    public void innerBlit(class_2960 atlas, int x1, int x2, int y1, int y2, int z, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (class_2960)atlas);
        RenderSystem.setShader(class_757::method_34548);
        Matrix4f matrix4f = this.pose.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_20888);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_39415(-1).method_22913(minU, minV).method_60803(this.packedLight);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)z).method_39415(-1).method_22913(minU, maxV).method_60803(this.packedLight);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)z).method_39415(-1).method_22913(maxU, maxV).method_60803(this.packedLight);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)z).method_39415(-1).method_22913(maxU, minV).method_60803(this.packedLight);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
    }

    public EntityMaid getMaid() {
        return this.maid;
    }

    public int getPackedLight() {
        return this.packedLight;
    }

    public float getPartialTicks() {
        return this.partialTicks;
    }

    public class_4587 getPoseStack() {
        return this.pose;
    }
}

