/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.sodium;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.animated.AnimatedGeoBone;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoMesh;
import com.mojang.blaze3d.systems.RenderSystem;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.EntityVertex;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

class SodiumGeoRenderer {
    static Vector3f C000 = new Vector3f();
    static Vector3f C100 = new Vector3f();
    static Vector3f C110 = new Vector3f();
    static Vector3f C010 = new Vector3f();
    static Vector3f C001 = new Vector3f();
    static Vector3f C101 = new Vector3f();
    static Vector3f C111 = new Vector3f();
    static Vector3f C011 = new Vector3f();
    static Vector3f dx = new Vector3f();
    static Vector3f dy = new Vector3f();
    static Vector3f dz = new Vector3f();
    static Vector3f nx = new Vector3f();
    static Vector3f ny = new Vector3f();
    static Vector3f nz = new Vector3f();
    private static final long SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)864L);
    private static final MemoryStack STACK = MemoryStack.create();

    SodiumGeoRenderer() {
    }

    private static int packUnsafe(float x, float y, float z) {
        int normX = (int)(x * 127.0f) & 0xFF;
        int normY = (int)(y * 127.0f) & 0xFF;
        int normZ = (int)(z * 127.0f) & 0xFF;
        return normZ << 16 | normY << 8 | normX;
    }

    static boolean renderCubesOfBone(AnimatedGeoBone bone, class_4587 poseStack, class_4588 buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog((class_4588)buffer);
        if (writer == null) {
            return false;
        }
        if (bone.isHidden()) {
            return true;
        }
        if (bone.cubesAreHidden()) {
            return true;
        }
        GeoMesh mesh = bone.geoBone().cubes();
        int color = (int)(alpha * 255.0f) << 24 | (int)(blue * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(red * 255.0f);
        for (int i = 0; i < mesh.getCubeCount(); ++i) {
            boolean mirrored;
            Matrix4f pose = poseStack.method_23760().method_23761();
            mesh.position(i).mulPosition((Matrix4fc)pose, C000);
            mesh.dx(i).mulDirection((Matrix4fc)pose, dx);
            mesh.dy(i).mulDirection((Matrix4fc)pose, dy);
            mesh.dz(i).mulDirection((Matrix4fc)pose, dz);
            C000.add((Vector3fc)dx, C100);
            C100.add((Vector3fc)dy, C110);
            C000.add((Vector3fc)dy, C010);
            C000.add((Vector3fc)dz, C001);
            C100.add((Vector3fc)dz, C101);
            C110.add((Vector3fc)dz, C111);
            C010.add((Vector3fc)dz, C011);
            dx.cross((Vector3fc)dy, nz).normalize();
            dy.cross((Vector3fc)dz, nx).normalize();
            dz.cross((Vector3fc)dx, ny).normalize();
            int faces = mesh.faces(i);
            boolean bl = mirrored = (faces & 0x40) != 0;
            if ((faces & 0x3F) == 63 && RenderSystem.getModelViewMatrix().m32() == 0.0f) {
                if ((SodiumGeoRenderer.C101.x + SodiumGeoRenderer.C000.x) * SodiumGeoRenderer.ny.x + (SodiumGeoRenderer.C101.y + SodiumGeoRenderer.C000.y) * SodiumGeoRenderer.ny.y + (SodiumGeoRenderer.C101.z + SodiumGeoRenderer.C000.z) * SodiumGeoRenderer.ny.z < 0.0f) {
                    faces &= mirrored ? -3 : -2;
                }
                if ((SodiumGeoRenderer.C110.x + SodiumGeoRenderer.C011.x) * SodiumGeoRenderer.ny.x + (SodiumGeoRenderer.C110.y + SodiumGeoRenderer.C011.y) * SodiumGeoRenderer.ny.y + (SodiumGeoRenderer.C110.z + SodiumGeoRenderer.C011.z) * SodiumGeoRenderer.ny.z > 0.0f) {
                    faces &= mirrored ? -2 : -3;
                }
                if ((SodiumGeoRenderer.C100.x + SodiumGeoRenderer.C010.x) * SodiumGeoRenderer.nz.x + (SodiumGeoRenderer.C100.y + SodiumGeoRenderer.C010.y) * SodiumGeoRenderer.nz.y + (SodiumGeoRenderer.C100.z + SodiumGeoRenderer.C010.z) * SodiumGeoRenderer.nz.z < 0.0f) {
                    faces &= mirrored ? -9 : -5;
                }
                if ((SodiumGeoRenderer.C001.x + SodiumGeoRenderer.C111.x) * SodiumGeoRenderer.nz.x + (SodiumGeoRenderer.C001.y + SodiumGeoRenderer.C111.y) * SodiumGeoRenderer.nz.y + (SodiumGeoRenderer.C001.z + SodiumGeoRenderer.C111.z) * SodiumGeoRenderer.nz.z > 0.0f) {
                    faces &= mirrored ? -5 : -9;
                }
                if ((SodiumGeoRenderer.C000.x + SodiumGeoRenderer.C011.x) * SodiumGeoRenderer.nx.x + (SodiumGeoRenderer.C000.y + SodiumGeoRenderer.C011.y) * SodiumGeoRenderer.nx.y + (SodiumGeoRenderer.C000.z + SodiumGeoRenderer.C011.z) * SodiumGeoRenderer.nx.z < 0.0f) {
                    faces &= mirrored ? -33 : -17;
                }
                if ((SodiumGeoRenderer.C101.x + SodiumGeoRenderer.C110.x) * SodiumGeoRenderer.nx.x + (SodiumGeoRenderer.C101.y + SodiumGeoRenderer.C110.y) * SodiumGeoRenderer.nx.y + (SodiumGeoRenderer.C101.z + SodiumGeoRenderer.C110.z) * SodiumGeoRenderer.nx.z > 0.0f) {
                    faces &= mirrored ? -17 : -33;
                }
            } else {
                Matrix3f normal = poseStack.method_23760().method_23762();
                mesh.dx(i).cross((Vector3fc)mesh.dy(i), nz);
                mesh.dy(i).cross((Vector3fc)mesh.dz(i), nx);
                mesh.dz(i).cross((Vector3fc)mesh.dx(i), ny);
                nx.mul((Matrix3fc)normal).normalize();
                ny.mul((Matrix3fc)normal).normalize();
                nz.mul((Matrix3fc)normal).normalize();
            }
            if (mirrored) {
                nx.mul(-1.0f);
                ny.mul(-1.0f);
                nz.mul(-1.0f);
            }
            int normalPX = SodiumGeoRenderer.packUnsafe(SodiumGeoRenderer.nx.x, SodiumGeoRenderer.nx.y, SodiumGeoRenderer.nx.z);
            int normalPY = SodiumGeoRenderer.packUnsafe(SodiumGeoRenderer.ny.x, SodiumGeoRenderer.ny.y, SodiumGeoRenderer.ny.z);
            int normalPZ = SodiumGeoRenderer.packUnsafe(SodiumGeoRenderer.nz.x, SodiumGeoRenderer.nz.y, SodiumGeoRenderer.nz.z);
            int normalNX = SodiumGeoRenderer.packUnsafe(-SodiumGeoRenderer.nx.x, -SodiumGeoRenderer.nx.y, -SodiumGeoRenderer.nx.z);
            int normalNY = SodiumGeoRenderer.packUnsafe(-SodiumGeoRenderer.ny.z, -SodiumGeoRenderer.ny.y, -SodiumGeoRenderer.ny.z);
            int normalNZ = SodiumGeoRenderer.packUnsafe(-SodiumGeoRenderer.nz.x, -SodiumGeoRenderer.nz.y, -SodiumGeoRenderer.nz.z);
            long ptr = SCRATCH_BUFFER;
            int vertexCount = 0;
            if ((faces & 1) != 0) {
                SodiumGeoRenderer.emitVertex(ptr, SodiumGeoRenderer.C101.x, SodiumGeoRenderer.C101.y, SodiumGeoRenderer.C101.z, color, mesh.downU0(i), mesh.downV1(i), packedOverlay, packedLight, normalNY);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C001.x, SodiumGeoRenderer.C001.y, SodiumGeoRenderer.C001.z, color, mesh.downU1(i), mesh.downV1(i), packedOverlay, packedLight, normalNY);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C000.x, SodiumGeoRenderer.C000.y, SodiumGeoRenderer.C000.z, color, mesh.downU1(i), mesh.downV0(i), packedOverlay, packedLight, normalNY);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C100.x, SodiumGeoRenderer.C100.y, SodiumGeoRenderer.C100.z, color, mesh.downU0(i), mesh.downV0(i), packedOverlay, packedLight, normalNY);
                ptr += 36L;
                vertexCount += 4;
            }
            if ((faces & 2) != 0) {
                SodiumGeoRenderer.emitVertex(ptr, SodiumGeoRenderer.C110.x, SodiumGeoRenderer.C110.y, SodiumGeoRenderer.C110.z, color, mesh.upU0(i), mesh.upV1(i), packedOverlay, packedLight, normalPY);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C010.x, SodiumGeoRenderer.C010.y, SodiumGeoRenderer.C010.z, color, mesh.upU1(i), mesh.upV1(i), packedOverlay, packedLight, normalPY);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C011.x, SodiumGeoRenderer.C011.y, SodiumGeoRenderer.C011.z, color, mesh.upU1(i), mesh.upV0(i), packedOverlay, packedLight, normalPY);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C111.x, SodiumGeoRenderer.C111.y, SodiumGeoRenderer.C111.z, color, mesh.upU0(i), mesh.upV0(i), packedOverlay, packedLight, normalPY);
                ptr += 36L;
                vertexCount += 4;
            }
            if ((faces & 4) != 0) {
                SodiumGeoRenderer.emitVertex(ptr, SodiumGeoRenderer.C100.x, SodiumGeoRenderer.C100.y, SodiumGeoRenderer.C100.z, color, mesh.northU0(i), mesh.northV1(i), packedOverlay, packedLight, normalNZ);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C000.x, SodiumGeoRenderer.C000.y, SodiumGeoRenderer.C000.z, color, mesh.northU1(i), mesh.northV1(i), packedOverlay, packedLight, normalNZ);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C010.x, SodiumGeoRenderer.C010.y, SodiumGeoRenderer.C010.z, color, mesh.northU1(i), mesh.northV0(i), packedOverlay, packedLight, normalNZ);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C110.x, SodiumGeoRenderer.C110.y, SodiumGeoRenderer.C110.z, color, mesh.northU0(i), mesh.northV0(i), packedOverlay, packedLight, normalNZ);
                ptr += 36L;
                vertexCount += 4;
            }
            if ((faces & 8) != 0) {
                SodiumGeoRenderer.emitVertex(ptr, SodiumGeoRenderer.C001.x, SodiumGeoRenderer.C001.y, SodiumGeoRenderer.C001.z, color, mesh.southU0(i), mesh.southV1(i), packedOverlay, packedLight, normalPZ);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C101.x, SodiumGeoRenderer.C101.y, SodiumGeoRenderer.C101.z, color, mesh.southU1(i), mesh.southV1(i), packedOverlay, packedLight, normalPZ);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C111.x, SodiumGeoRenderer.C111.y, SodiumGeoRenderer.C111.z, color, mesh.southU1(i), mesh.southV0(i), packedOverlay, packedLight, normalPZ);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C011.x, SodiumGeoRenderer.C011.y, SodiumGeoRenderer.C011.z, color, mesh.southU0(i), mesh.southV0(i), packedOverlay, packedLight, normalPZ);
                ptr += 36L;
                vertexCount += 4;
            }
            if ((faces & 0x10) != 0) {
                SodiumGeoRenderer.emitVertex(ptr, SodiumGeoRenderer.C000.x, SodiumGeoRenderer.C000.y, SodiumGeoRenderer.C000.z, color, mesh.westU0(i), mesh.westV1(i), packedOverlay, packedLight, normalNX);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C001.x, SodiumGeoRenderer.C001.y, SodiumGeoRenderer.C001.z, color, mesh.westU1(i), mesh.westV1(i), packedOverlay, packedLight, normalNX);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C011.x, SodiumGeoRenderer.C011.y, SodiumGeoRenderer.C011.z, color, mesh.westU1(i), mesh.westV0(i), packedOverlay, packedLight, normalNX);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C010.x, SodiumGeoRenderer.C010.y, SodiumGeoRenderer.C010.z, color, mesh.westU0(i), mesh.westV0(i), packedOverlay, packedLight, normalNX);
                ptr += 36L;
                vertexCount += 4;
            }
            if ((faces & 0x20) != 0) {
                SodiumGeoRenderer.emitVertex(ptr, SodiumGeoRenderer.C101.x, SodiumGeoRenderer.C101.y, SodiumGeoRenderer.C101.z, color, mesh.eastU0(i), mesh.eastV1(i), packedOverlay, packedLight, normalPX);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C100.x, SodiumGeoRenderer.C100.y, SodiumGeoRenderer.C100.z, color, mesh.eastU1(i), mesh.eastV1(i), packedOverlay, packedLight, normalPX);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C110.x, SodiumGeoRenderer.C110.y, SodiumGeoRenderer.C110.z, color, mesh.eastU1(i), mesh.eastV0(i), packedOverlay, packedLight, normalPX);
                SodiumGeoRenderer.emitVertex(ptr += 36L, SodiumGeoRenderer.C111.x, SodiumGeoRenderer.C111.y, SodiumGeoRenderer.C111.z, color, mesh.eastU0(i), mesh.eastV0(i), packedOverlay, packedLight, normalPX);
                ptr += 36L;
                vertexCount += 4;
            }
            SodiumGeoRenderer.flush(writer, vertexCount);
        }
        return true;
    }

    private static void emitVertex(long ptr, float x, float y, float z, int color, float u, float v, int packedOverlay, int packedLight, int normal) {
        EntityVertex.write((long)ptr, (float)x, (float)y, (float)z, (int)color, (float)u, (float)v, (int)packedOverlay, (int)packedLight, (int)normal);
    }

    private static void flush(VertexBufferWriter writer, int vertexCount) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            writer.push(stack, SCRATCH_BUFFER, vertexCount, EntityVertex.FORMAT);
        }
    }
}

