/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class GunShootTargetTask
extends class_4097<EntityMaid> {
    private int attackCooldown = -1;
    private int seeTime;

    public GunShootTargetTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456), 1200);
    }

    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        Optional memory = owner.method_18868().method_18904(class_4140.field_22355);
        if (memory.isPresent()) {
            class_1309 target = (class_1309)memory.get();
            return IGun.mainhandHoldGun((class_1309)owner) && owner.canSee(target);
        }
        return false;
    }

    protected boolean canStillUse(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        return entityIn.method_18868().method_18896(class_4140.field_22355) && this.checkExtraStartConditions(worldIn, entityIn);
    }

    protected void start(class_3218 worldIn, EntityMaid entityIn, long gameTimeIn) {
        entityIn.setSwingingArms(true);
    }

    protected void tick(class_3218 worldIn, EntityMaid owner, long gameTime) {
        owner.method_18868().method_18904(class_4140.field_22355).ifPresent(target -> {
            boolean seeTimeMoreThanZero;
            owner.method_5988().method_20248(target.method_23317(), target.method_23318(), target.method_23321());
            boolean canSee = owner.canSee((class_1309)target);
            boolean bl = seeTimeMoreThanZero = this.seeTime > 0;
            if (canSee != seeTimeMoreThanZero) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (--this.attackCooldown <= 0 && this.seeTime >= -60 && canSee) {
                class_1799 mainHandItem = owner.method_6047();
                IGun iGun = IGun.getIGunOrNull((class_1799)mainHandItem);
                if (iGun == null) {
                    this.attackCooldown = 100;
                    return;
                }
                class_2960 gunId = iGun.getGunId(mainHandItem);
                TimelessAPI.getCommonGunIndex((class_2960)gunId).ifPresentOrElse(index -> {
                    try {
                        this.performGunAttack(owner, (class_1309)target, mainHandItem, iGun, (CommonGunIndex)index);
                    }
                    catch (Exception e) {
                        TouhouLittleMaid.LOGGER.error("Error while performing gun attack for EntityMaid: {}", (Object)owner.method_5667(), (Object)e);
                        this.attackCooldown = 100;
                    }
                }, () -> {
                    this.attackCooldown = 100;
                });
            }
        });
    }

    public void performGunAttack(EntityMaid shooter, class_1309 target, class_1799 gunItem, IGun iGun, CommonGunIndex gunIndex) {
        GunData gunData = gunIndex.getGunData();
        double x = target.method_23317() - shooter.method_23317();
        double y = target.method_23320() - shooter.method_23320();
        double z = target.method_23321() - shooter.method_23321();
        float yaw = (float)(-Math.toDegrees(Math.atan2(x, z)));
        float pitch = (float)(-Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z))));
        float radius = shooter.method_18413();
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)shooter);
        ShootResult result = gunOperator.shoot(() -> Float.valueOf(pitch), () -> Float.valueOf(yaw));
        if (result == ShootResult.ID_NOT_EXIST || result == ShootResult.NOT_GUN) {
            this.attackCooldown = 100;
            return;
        }
        String sniper = GunTabType.SNIPER.name().toLowerCase(Locale.ENGLISH);
        if (gunIndex.getType().equals(sniper) && !gunOperator.getSynIsAiming()) {
            gunOperator.aim(true);
            this.attackCooldown = Math.round(gunData.getAimTime() * 20.0f) + 2;
            return;
        }
        if (!gunIndex.getType().equals(sniper)) {
            float distance = shooter.method_5739((class_1297)target);
            if (distance <= radius && gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
                this.attackCooldown = Math.round(gunData.getAimTime() * 20.0f) + 2;
                return;
            }
            if (distance > radius && !gunOperator.getSynIsAiming()) {
                gunOperator.aim(true);
                this.attackCooldown = Math.round(gunData.getAimTime() * 20.0f) + 2;
                return;
            }
        }
        if (result == ShootResult.NOT_DRAW) {
            gunOperator.draw(() -> ((EntityMaid)shooter).method_6047());
            this.attackCooldown = Math.round(gunData.getDrawTime() * 20.0f) + 2;
            return;
        }
        if (result == ShootResult.NEED_BOLT) {
            gunOperator.bolt();
            this.attackCooldown = Math.round(gunData.getBoltActionTime() * 20.0f) + 2;
            return;
        }
        if (result == ShootResult.NO_AMMO) {
            gunOperator.reload();
            float emptyTime = gunData.getReloadData().getCooldown().getEmptyTime();
            this.attackCooldown = Math.round(emptyTime * 20.0f) + 2;
            return;
        }
        FireMode fireMode = iGun.getFireMode(gunItem);
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST) {
            this.attackCooldown = 10 + shooter.method_59922().method_43048(5);
            return;
        }
        this.attackCooldown = 2;
    }

    protected void stop(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        this.seeTime = 0;
        this.attackCooldown = -1;
        maid.setSwingingArms(false);
        this.stopAim(maid);
    }

    private void stopAim(EntityMaid maid) {
        class_1799 mainHandItem = maid.method_6047();
        IGun iGun = IGun.getIGunOrNull((class_1799)mainHandItem);
        if (iGun == null) {
            return;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getCommonGunIndex((class_2960)gunId).ifPresent(gunIndex -> {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)maid);
            if (gunOperator.getSynIsAiming()) {
                gunOperator.aim(false);
            }
        });
    }
}

