/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.IPlayerMixin;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.EntityAccessor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import org.jetbrains.annotations.Nullable;

public class MaidFollowOwnerVehicleTask
extends class_4097<EntityMaid> {
    private static final int RANGE = 3;
    private final float speedModifier;
    private final int stopDistance;
    private class_1297 ownerControlledVehicle;
    private Type type = Type.NONE;

    public MaidFollowOwnerVehicleTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18458));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid maid) {
        if (!this.maidStateConditions(maid)) {
            return false;
        }
        class_1309 owner = maid.method_35057();
        if (!this.ownerStateConditions(owner) || !(owner instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)owner;
        class_1297 ownerControlledVehicle = owner.method_49694();
        class_1297 maidVehicle = maid.method_5854();
        if (ownerControlledVehicle == null) {
            boolean maidInDismountRange;
            boolean isCooldown = ((IPlayerMixin)player).tlmInRemoveVehicleCooldown();
            boolean bl = maidInDismountRange = maid.method_5739((class_1297)owner) < 3.0f;
            if (maid.method_5765() && isCooldown && maidInDismountRange) {
                this.type = Type.STOP;
                return true;
            }
            return false;
        }
        if (maidVehicle != null && maidVehicle == ownerControlledVehicle) {
            return false;
        }
        if (!((EntityAccessor)ownerControlledVehicle).tlmCanAddPassenger((class_1297)maid)) {
            return false;
        }
        if (maid.method_24516(ownerControlledVehicle, 3.0)) {
            this.ownerControlledVehicle = ownerControlledVehicle;
            this.type = Type.RIDE;
            return true;
        }
        if (!maid.method_18868().method_18896(class_4140.field_18445)) {
            class_4215.method_24557((class_1309)maid, (class_1297)ownerControlledVehicle, (float)this.speedModifier, (int)this.stopDistance);
            return false;
        }
        return false;
    }

    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        switch (this.type.ordinal()) {
            case 0: {
                Optional.ofNullable(this.ownerControlledVehicle).ifPresent(arg_0 -> ((EntityMaid)maid).method_5804(arg_0));
                break;
            }
            case 1: {
                maid.method_5848();
            }
        }
    }

    protected void stop(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        this.ownerControlledVehicle = null;
        this.type = Type.NONE;
    }

    private boolean canBrainMoving(EntityMaid maid) {
        return !maid.isMaidInSittingPose() && !maid.method_6113() && !maid.method_60953();
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && this.canBrainMoving(maid) && maid.isRideable();
    }

    private boolean ownerStateConditions(@Nullable class_1309 owner) {
        return owner != null && owner.method_5805() && !owner.method_7325() && !owner.method_29504();
    }

    static enum Type {
        RIDE,
        STOP,
        NONE;

    }
}

