/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.info;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.util.GetJarResources;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class CommonDefaultPack {
    private static final String CUSTOM_PACK_DIR_NAME = "tlm_custom_pack";
    private static final String DEFAULT_PACK_NAME = "touhou_little_maid-1.0.0";
    private static final String LEGACY_PACK_NAME = "touhou_little_maid-1.0.0.zip";
    private static final Path PACK_FOLDER = FabricLoader.getInstance().getGameDir().resolve("tlm_custom_pack");
    private static final Marker MARKER = MarkerManager.getMarker((String)"CommonDefaultPack");

    public static void initCommonDefaultPack() {
        TouhouLittleMaid.LOGGER.info("common default pack init start...");
        StopWatch watch = StopWatch.createStarted();
        File packFolder = PACK_FOLDER.resolve(DEFAULT_PACK_NAME).toFile();
        CommonDefaultPack.createCustomPackFolder(packFolder);
        CommonDefaultPack.archiveLegacyDefaultPack();
        CommonDefaultPack.unpackDefaultPack(packFolder);
        watch.stop();
        double time = (double)watch.getTime(TimeUnit.MICROSECONDS) / 1000.0;
        TouhouLittleMaid.LOGGER.info("common default pack init finished, cost time: {} ms", (Object)time);
    }

    private static void createCustomPackFolder(File packFolder) {
        if (!packFolder.isDirectory()) {
            try {
                Files.createDirectories(packFolder.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                TouhouLittleMaid.LOGGER.error(MARKER, "Failed to create folder {}", (Object)packFolder.getAbsolutePath(), (Object)e);
            }
        }
    }

    private static void archiveLegacyDefaultPack() {
        File legacyFile = PACK_FOLDER.resolve(LEGACY_PACK_NAME).toFile();
        if (legacyFile.isFile()) {
            try {
                String disabledFileName = "touhou_little_maid-1.0.0.zip.disabled";
                FileUtils.moveFile((File)legacyFile, (File)legacyFile.toPath().resolveSibling(disabledFileName).toFile());
            }
            catch (IOException e) {
                TouhouLittleMaid.LOGGER.error(MARKER, "Failed to rename legacy default pack", (Throwable)e);
            }
        }
    }

    private static void unpackDefaultPack(File packFolder) {
        String jarDefaultPackPath = "/assets/%s/%s/%s".formatted("touhou_little_maid", CUSTOM_PACK_DIR_NAME, DEFAULT_PACK_NAME);
        try {
            GetJarResources.copyFolder(jarDefaultPackPath, packFolder.toPath());
        }
        catch (IOException | URISyntaxException e) {
            TouhouLittleMaid.LOGGER.error(MARKER, "Failed to unpack default pack: {}", (Object)jarDefaultPackPath, (Object)e);
        }
    }
}

