/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.client.entity.GeckoChairEntity;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.ChairConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import com.github.tartaricacid.touhoulittlemaid.network.message.OpenChairGuiPackage;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5321;
import net.minecraft.class_8710;

public class EntityChair
extends AbstractEntityFromItem {
    public static final class_1299<EntityChair> TYPE = class_1299.class_1300.method_5903(EntityChair::new, (class_1311)class_1311.field_17715).method_17687(0.875f, 0.5f).method_27299(10).method_5905("chair");
    private static final class_2940<String> MODEL_ID = class_2945.method_12791(EntityChair.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Float> MOUNTED_HEIGHT = class_2945.method_12791(EntityChair.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> TAMEABLE_CAN_RIDE = class_2945.method_12791(EntityChair.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(EntityChair.class, (class_2941)class_2943.field_13313);
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:cushion";
    @Environment(value=EnvType.CLIENT)
    private GeckoChairEntity animatable;

    protected EntityChair(class_1299<EntityChair> type, class_1937 worldIn) {
        super(type, worldIn);
        if (worldIn.method_8608()) {
            this.animatable = new GeckoChairEntity(this);
        }
    }

    public EntityChair(class_1937 worldIn) {
        this(TYPE, worldIn);
    }

    public EntityChair(class_1937 worldIn, double x, double y, double z, float yaw) {
        this(TYPE, worldIn);
        this.method_5814(x, y, z);
        this.method_5710(yaw, 0.0f);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MODEL_ID, (Object)DEFAULT_MODEL_ID);
        builder.method_56912(MOUNTED_HEIGHT, (Object)Float.valueOf(0.0f));
        builder.method_56912(TAMEABLE_CAN_RIDE, (Object)true);
        builder.method_56912(OWNER_UUID, Optional.empty());
    }

    protected void method_6070() {
        if (!this.isTameableCanRide()) {
            return;
        }
        if (!this.field_6002.field_9236) {
            List list = this.field_6002.method_8390(class_1321.class, this.method_5829().method_1012(0.0, 0.5, 0.0), e -> !e.method_6172() && !e.method_5765() && e.method_5685().isEmpty());
            list.stream().findFirst().ifPresent(entity -> entity.method_5804((class_1297)this));
        }
    }

    public boolean method_5863() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_5715()) {
            if (player.method_5998(hand).method_7920(player, (class_1309)this, hand).method_23665()) {
                return class_1269.field_5812;
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new OpenChairGuiPackage(this.method_5628()));
            }
        } else if (!this.field_6002.field_9236 && this.method_5685().isEmpty() && !player.method_5765()) {
            player.method_5804((class_1297)this);
        }
        return class_1269.field_5812;
    }

    @Nonnull
    @Environment(value=EnvType.CLIENT)
    public class_238 method_5830() {
        BedrockModel model = CustomPackLoader.CHAIR_MODELS.getModel(this.getModelId()).orElse(null);
        if (model == null) {
            return super.method_5830();
        }
        return model.getRenderBoundingBox().method_997(this.method_19538());
    }

    protected class_243 method_52533(class_1297 entity, class_4048 dimensions, float partialTick) {
        return new class_243(0.0, (double)this.getMountedHeight() + 0.125, 0.0);
    }

    @Override
    protected boolean canKillEntity(class_1657 player) {
        if (((Boolean)ChairConfig.CHAIR_CAN_DESTROYED_BY_ANYONE.get()).booleanValue()) {
            return true;
        }
        return this.getOwnerUUID().map(uuid -> player.method_5667().equals(uuid)).orElse(true);
    }

    @Override
    protected class_3414 getHitSound() {
        return class_3417.field_14983;
    }

    @Override
    protected class_1792 getWithItem() {
        return InitItems.CHAIR;
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("model_id", 8)) {
            this.setModelId(compound.method_10558("model_id"));
        }
        if (compound.method_10573("mounted_height", 5)) {
            this.setMountedHeight(compound.method_10583("mounted_height"));
        }
        if (compound.method_10573("tameable_can_ride", 1)) {
            this.setTameableCanRide(compound.method_10577("tameable_can_ride"));
        }
        if (compound.method_10545("owner_uuid")) {
            this.setOwnerUUID(class_2512.method_25930((class_2520)Objects.requireNonNull(compound.method_10580("owner_uuid"))));
        }
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10582("model_id", this.getModelId());
        compound.method_10548("mounted_height", this.getMountedHeight());
        compound.method_10556("tameable_can_ride", this.isTameableCanRide());
        this.getOwnerUUID().ifPresent(uuid -> compound.method_25927("owner_uuid", uuid));
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 firstPassenger = this.method_31483();
        if (firstPassenger instanceof class_1309) {
            class_1309 livingEntity = (class_1309)firstPassenger;
            return livingEntity;
        }
        return super.method_5642();
    }

    public String getModelId() {
        return (String)this.field_6011.method_12789(MODEL_ID);
    }

    public void setModelId(String modelId) {
        this.field_6011.method_12778(MODEL_ID, (Object)modelId);
    }

    public float getMountedHeight() {
        return ((Float)this.field_6011.method_12789(MOUNTED_HEIGHT)).floatValue();
    }

    public void setMountedHeight(float height) {
        height = class_3532.method_15363((float)height, (float)-0.5f, (float)2.5f);
        this.field_6011.method_12778(MOUNTED_HEIGHT, (Object)Float.valueOf(height));
    }

    public boolean isTameableCanRide() {
        return (Boolean)this.field_6011.method_12789(TAMEABLE_CAN_RIDE);
    }

    public void setTameableCanRide(boolean canRide) {
        this.field_6011.method_12778(TAMEABLE_CAN_RIDE, (Object)canRide);
    }

    public Optional<UUID> getOwnerUUID() {
        return (Optional)this.field_6011.method_12789(OWNER_UUID);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(@Nullable class_1657 player) {
        if (player != null) {
            this.setOwnerUUID(player.method_5667());
        }
    }

    public boolean hasPassenger() {
        return !this.method_5685().isEmpty();
    }

    public float getPassengerYaw() {
        if (!this.method_5685().isEmpty()) {
            return ((class_1297)this.method_5685().getFirst()).method_36454();
        }
        return 0.0f;
    }

    public float getYaw() {
        return this.method_36454();
    }

    public float getPassengerPitch() {
        if (!this.method_5685().isEmpty()) {
            return ((class_1297)this.method_5685().getFirst()).method_36455();
        }
        return 0.0f;
    }

    @Deprecated
    public int getDim() {
        class_5321 dim = this.field_6002.method_27983();
        if (dim.equals(class_1937.field_25179)) {
            return 0;
        }
        if (dim.equals(class_1937.field_25180)) {
            return -1;
        }
        if (dim.equals(class_1937.field_25181)) {
            return 1;
        }
        return 0;
    }

    @Override
    protected class_1799 getKilledStack() {
        return ItemChair.setData(InitItems.CHAIR.method_7854(), new ItemChair.Data(this.getModelId(), this.getMountedHeight(), this.isTameableCanRide(), this.method_5740()));
    }

    @Environment(value=EnvType.CLIENT)
    public GeckoChairEntity getAnimatableEntity() {
        return this.animatable;
    }
}

