/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.projectile;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuColor;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.DanmakuType;
import com.github.tartaricacid.touhoulittlemaid.init.InitDamage;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

public class EntityDanmaku
extends class_1682 {
    public static final class_1299<EntityDanmaku> TYPE = class_1299.class_1300.method_5903(EntityDanmaku::new, (class_1311)class_1311.field_17715).method_17687(0.25f, 0.25f).method_27299(6).method_27300(10).method_5904().method_5905("danmaku");
    private static final int MAX_TICKS_EXISTED = 200;
    private static final class_2940<Integer> DANMAKU_TYPE = class_2945.method_12791(EntityDanmaku.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> COLOR = class_2945.method_12791(EntityDanmaku.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DAMAGE = class_2945.method_12791(EntityDanmaku.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> GRAVITY = class_2945.method_12791(EntityDanmaku.class, (class_2941)class_2943.field_13320);
    private int impedingLevel = 0;
    private boolean hurtEnderman = false;

    public EntityDanmaku(class_1299<? extends class_1682> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public EntityDanmaku(class_1937 worldIn, class_1309 throwerIn) {
        super(TYPE, throwerIn, worldIn);
    }

    public EntityDanmaku(class_1937 worldIn, double x, double y, double z) {
        super(TYPE, x, y, z, worldIn);
    }

    private static boolean hasSameOwner(class_1321 tameableA, class_1321 tameableB) {
        if (tameableA.method_6139() == null) {
            return false;
        }
        return tameableA.method_6139().equals(tameableB.method_6139());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DANMAKU_TYPE, (Object)DanmakuType.PELLET.ordinal());
        builder.method_56912(COLOR, (Object)DanmakuColor.RED.ordinal());
        builder.method_56912(DAMAGE, (Object)Float.valueOf(1.0f));
        builder.method_56912(GRAVITY, (Object)Float.valueOf(0.01f));
    }

    protected void method_24920(class_3965 result) {
        class_2338 pos = result.method_17777();
        class_2680 blockState = this.field_6002.method_8320(pos);
        if (!blockState.method_26220((class_1922)this.field_6002, pos).method_1110()) {
            this.method_31472();
        }
    }

    protected void method_7454(class_3966 result) {
        class_1309 livingEntity;
        class_1297 thrower = this.method_24921();
        class_1297 hit = result.method_17782();
        if (thrower instanceof class_1321) {
            class_1321 hitTameable;
            class_1321 tameable = (class_1321)thrower;
            if (tameable instanceof EntityMaid && hit instanceof class_1657) {
                this.method_31472();
                return;
            }
            if (hit instanceof class_1321 && EntityDanmaku.hasSameOwner(tameable, hitTameable = (class_1321)hit)) {
                this.method_31472();
                return;
            }
            if (hit instanceof class_1309 && tameable.method_5722((class_1297)(livingEntity = (class_1309)hit))) {
                this.method_31472();
                return;
            }
            class_2960 registryName = class_7923.field_41177.method_10221((Object)hit.method_5864());
            if (registryName != null && ((List)MaidConfig.MAID_RANGED_ATTACK_IGNORE.get()).contains(registryName.toString())) {
                this.method_31472();
                return;
            }
        }
        if (thrower != null && !hit.method_5779(thrower)) {
            class_1282 source = InitDamage.danmakuDamage(thrower, this);
            hit.method_5643(source, this.getDamage());
            if (this.impedingLevel > 0 && hit instanceof class_1309) {
                livingEntity = (class_1309)hit;
                int duration = (20 + this.impedingLevel * 10) * 20;
                livingEntity.method_6092(new class_1293(class_1294.field_5909, duration, this.impedingLevel));
            }
            this.method_31472();
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 > 200) {
            this.method_31472();
        }
    }

    public double method_56989() {
        return ((Float)this.field_6011.method_12789(GRAVITY)).floatValue();
    }

    public EntityDanmaku setGravityVelocity(float gravity) {
        this.field_6011.method_12778(GRAVITY, (Object)Float.valueOf(gravity));
        return this;
    }

    public DanmakuType getDanmakuType() {
        return DanmakuType.getType((Integer)this.field_6011.method_12789(DANMAKU_TYPE));
    }

    public EntityDanmaku setDanmakuType(DanmakuType type) {
        this.field_6011.method_12778(DANMAKU_TYPE, (Object)type.ordinal());
        return this;
    }

    public DanmakuColor getColor() {
        return DanmakuColor.getColor((Integer)this.field_6011.method_12789(COLOR));
    }

    public EntityDanmaku setColor(DanmakuColor color) {
        this.field_6011.method_12778(COLOR, (Object)color.ordinal());
        return this;
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(DAMAGE)).floatValue();
    }

    public EntityDanmaku setDamage(float damage) {
        this.field_6011.method_12778(DAMAGE, (Object)Float.valueOf(damage));
        return this;
    }

    public EntityDanmaku setImpedingLevel(int impedingLevel) {
        this.impedingLevel = impedingLevel;
        return this;
    }

    public EntityDanmaku setHurtEnderman(boolean hurtEnderman) {
        this.hurtEnderman = hurtEnderman;
        return this;
    }

    public boolean isHurtEnderman() {
        return this.hurtEnderman;
    }
}

