/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityExtinguishingAgent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4816;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5134;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class TaskAttack
implements IAttackTask {
    public static final class_2960 UID = class_2960.method_60655((String)"touhou_little_maid", (String)"attack");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8802.method_7854();
    }

    @Override
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, InitSounds.MAID_ATTACK, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(this::hasAssaultWeapon, IAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasAssaultWeapon(maid) || this.farAway((class_1309)target, maid));
        class_7893 moveToTargetTask = class_4822.method_47094((float)0.6f);
        class_7894 attackTargetTask = class_4816.method_46987((int)20);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)moveToTargetTask), Pair.of((Object)5, (Object)attackTargetTask), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(this::hasAssaultWeapon, IAttackTask::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasAssaultWeapon(maid) || this.farAway((class_1309)target, maid));
        class_7894 attackTargetTask = class_4816.method_46987((int)20);
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)attackTargetTask), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
    }

    @Override
    public boolean hasExtraAttack(EntityMaid maid, class_1297 target) {
        return maid.method_6079().method_31574(InitItems.EXTINGUISHER) && target.method_5753();
    }

    @Override
    public boolean doExtraAttack(EntityMaid maid, class_1297 target) {
        class_1937 world = maid.field_6002;
        class_238 aabb = target.method_5829().method_1009(1.5, 1.0, 1.5);
        List extinguishingAgents = world.method_8390(EntityExtinguishingAgent.class, aabb, class_1297::method_5805);
        if (extinguishingAgents.isEmpty()) {
            world.method_8649((class_1297)new EntityExtinguishingAgent(world, target.method_19538()));
            maid.method_6079().method_7970(1, (class_1309)maid, class_1304.field_6171);
            return true;
        }
        return false;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"assault_weapon", this::hasAssaultWeapon), Pair.of((Object)"extinguisher", this::hasExtinguisher)});
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        class_9285 attributeModifiers = (class_9285)stack.method_57824(class_9334.field_49636);
        return attributeModifiers != null && attributeModifiers.comp_2393().stream().anyMatch(modifier -> modifier.comp_2395().method_55838(class_5134.field_23721));
    }

    private boolean hasAssaultWeapon(EntityMaid maid) {
        return this.isWeapon(maid, maid.method_6047());
    }

    private boolean hasExtinguisher(EntityMaid maid) {
        return maid.method_6079().method_31574(InitItems.EXTINGUISHER);
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        if (!target.method_5805()) {
            return true;
        }
        boolean enable = maid.isHomeModeEnable();
        float radius = maid.method_18413();
        if (!enable && maid.method_35057() != null) {
            return maid.method_35057().method_5739((class_1297)target) > radius;
        }
        return maid.method_5739((class_1297)target) > radius;
    }
}

