/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.binding.ContextBinding;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.BiomeHasAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.BiomeHasAnyTag;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EmptyFunction;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EquippedItemAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.EquippedItemAnyTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemMaxDurability;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemNameAny;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.ItemRemainingDurability;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.Position;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.PositionDelta;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.RelativeBlockHasAllTags;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.builtin.query.RelativeBlockHasAnyTag;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.MolangUtils;
import com.github.tartaricacid.touhoulittlemaid.util.EquipmentUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5498;

public class QueryBinding
extends ContextBinding {
    public static final QueryBinding INSTANCE = new QueryBinding();

    private QueryBinding() {
        this.function("biome_has_all_tags", new BiomeHasAllTags());
        this.function("biome_has_any_tag", new BiomeHasAnyTag());
        this.function("relative_block_has_all_tags", new RelativeBlockHasAllTags());
        this.function("relative_block_has_any_tag", new RelativeBlockHasAnyTag());
        this.function("is_item_name_any", new ItemNameAny());
        this.function("equipped_item_all_tags", new EquippedItemAllTags());
        this.function("equipped_item_any_tag", new EquippedItemAnyTags());
        this.function("position", new Position());
        this.function("position_delta", new PositionDelta());
        this.function("max_durability", new ItemMaxDurability());
        this.function("remaining_durability", new ItemRemainingDurability());
        this.var("actor_count", ctx -> ctx.level().method_18120());
        this.var("anim_time", ctx -> ctx.animationControllerContext().animTime());
        this.var("life_time", ctx -> ctx.geoInstance().getSeekTime() / 20.0);
        this.var("head_x_rotation", ctx -> Float.valueOf(ctx.data().netHeadYaw));
        this.var("head_y_rotation", ctx -> Float.valueOf(ctx.data().headPitch));
        this.var("moon_phase", ctx -> ctx.level().method_30273());
        this.var("time_of_day", ctx -> Float.valueOf(MolangUtils.normalizeTime(ctx.level().method_8532())));
        this.var("time_stamp", ctx -> ctx.level().method_8532());
        this.entityVar("yaw_speed", ctx -> Float.valueOf(QueryBinding.getYawSpeed((class_1297)ctx.entity())));
        this.entityVar("cardinal_facing_2d", ctx -> ((class_1297)ctx.entity()).method_5735().method_10146());
        this.entityVar("distance_from_camera", ctx -> ctx.mc().field_1773.method_19418().method_19326().method_1022(((class_1297)ctx.entity()).method_19538()));
        this.entityVar("eye_target_x_rotation", ctx -> Float.valueOf(((class_1297)ctx.entity()).method_5695(ctx.animationEvent().getPartialTick())));
        this.entityVar("eye_target_y_rotation", ctx -> Float.valueOf(((class_1297)ctx.entity()).method_5705(ctx.animationEvent().getPartialTick())));
        this.entityVar("ground_speed", ctx -> Float.valueOf(QueryBinding.getGroundSpeed((class_1297)ctx.entity())));
        this.entityVar("modified_distance_moved", ctx -> Float.valueOf(((class_1297)ctx.entity()).field_5973));
        this.entityVar("vertical_speed", ctx -> Float.valueOf(QueryBinding.getVerticalSpeed((class_1297)ctx.entity())));
        this.entityVar("walk_distance", ctx -> Float.valueOf(((class_1297)ctx.entity()).field_5994));
        this.entityVar("has_rider", ctx -> ((class_1297)ctx.entity()).method_5782());
        this.entityVar("is_first_person", ctx -> ctx.mc().field_1690.method_31044() == class_5498.field_26664);
        this.entityVar("is_in_water", ctx -> ((class_1297)ctx.entity()).method_5799());
        this.entityVar("is_in_water_or_rain", ctx -> ((class_1297)ctx.entity()).method_5637());
        this.entityVar("is_on_fire", ctx -> ((class_1297)ctx.entity()).method_5809());
        this.entityVar("is_on_ground", ctx -> ((class_1297)ctx.entity()).method_24828());
        this.entityVar("is_riding", ctx -> ((class_1297)ctx.entity()).method_5765());
        this.entityVar("is_sneaking", ctx -> ((class_1297)ctx.entity()).method_24828() && ((class_1297)ctx.entity()).method_18376() == class_4050.field_18081);
        this.entityVar("is_spectator", ctx -> ((class_1297)ctx.entity()).method_7325());
        this.entityVar("is_sprinting", ctx -> ((class_1297)ctx.entity()).method_5624());
        this.entityVar("is_swimming", ctx -> ((class_1297)ctx.entity()).method_5681());
        this.livingEntityVar("body_x_rotation", ctx -> Float.valueOf(class_3532.method_16439((float)ctx.animationEvent().getPartialTick(), (float)((class_1309)ctx.entity()).field_6004, (float)((class_1309)ctx.entity()).method_36455())));
        this.livingEntityVar("body_y_rotation", ctx -> Float.valueOf(class_3532.method_15393((float)class_3532.method_16439((float)ctx.animationEvent().getPartialTick(), (float)((class_1309)ctx.entity()).field_6220, (float)((class_1309)ctx.entity()).field_6283))));
        this.livingEntityVar("health", ctx -> Float.valueOf(((class_1309)ctx.entity()).method_6032()));
        this.livingEntityVar("max_health", ctx -> Float.valueOf(((class_1309)ctx.entity()).method_6063()));
        this.livingEntityVar("hurt_time", ctx -> ((class_1309)ctx.entity()).field_6235);
        this.livingEntityVar("is_eating", ctx -> ((class_1309)ctx.entity()).method_6030().method_7976() == class_1839.field_8950);
        this.livingEntityVar("is_playing_dead", ctx -> ((class_1309)ctx.entity()).method_29504());
        this.livingEntityVar("is_sleeping", ctx -> ((class_1309)ctx.entity()).method_6113());
        this.livingEntityVar("is_using_item", ctx -> ((class_1309)ctx.entity()).method_6115());
        this.livingEntityVar("item_in_use_duration", ctx -> (double)((class_1309)ctx.entity()).method_6048() / 20.0);
        this.livingEntityVar("item_max_use_duration", ctx -> QueryBinding.getMaxUseDuration((class_1309)ctx.entity()) / 20.0);
        this.livingEntityVar("item_remaining_use_duration", ctx -> (double)((class_1309)ctx.entity()).method_6014() / 20.0);
        this.livingEntityVar("equipment_count", ctx -> QueryBinding.getEquipmentCount((class_1309)ctx.entity()));
        this.function("debug_output", new EmptyFunction());
        this.var("has_cape", ctx -> false);
        this.var("cape_flap_amount", ctx -> 0);
        this.maidEntityVar("player_level", ctx -> ((EntityMaid)ctx.entity()).getExperience());
        this.mobEntityVar("is_jumping", ctx -> !((class_1308)ctx.entity()).method_5765() && !((class_1308)ctx.entity()).method_24828() && !((class_1308)ctx.entity()).method_5799());
    }

    private static int getEquipmentCount(class_1309 entity) {
        int count = 0;
        for (class_1304 slot : class_1304.values()) {
            class_1799 stack;
            if (!slot.method_46643() || (stack = EquipmentUtil.getEquippedItem(entity, slot)).method_7960()) continue;
            ++count;
        }
        return count;
    }

    private static double getMaxUseDuration(class_1309 player) {
        class_1799 useItem = player.method_6030();
        if (useItem.method_7960()) {
            return 0.0;
        }
        return useItem.method_7935(player);
    }

    private static float getYawSpeed(class_1297 entity) {
        return 20.0f * (entity.method_36454() - entity.field_5982);
    }

    private static float getGroundSpeed(class_1297 player) {
        class_243 velocity = player.method_18798();
        return 20.0f * class_3532.method_15355((float)((float)(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350)));
    }

    private static float getVerticalSpeed(class_1297 entity) {
        return 20.0f * (float)(entity.method_19538().field_1351 - entity.field_6036);
    }
}

