/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.IItemHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.SlotItemHandler;
import com.github.tartaricacid.touhoulittlemaid.init.InitCapabilities;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_6862;
import net.minecraft.class_9636;

public abstract class MaidMainContainer
extends AbstractMaidContainer {
    protected static final int PLAYER_INVENTORY_SIZE = 36;
    private static final class_2960 EMPTY_MAINHAND_SLOT = class_2960.method_60654((String)"item/empty_slot_sword");
    private static final class_2960 EMPTY_BACK_SHOW_SLOT = class_2960.method_60655((String)"touhou_little_maid", (String)"slot/empty_back_show_slot");
    private static final class_2960[] TEXTURE_EMPTY_SLOTS = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
    private static final class_1304[] SLOT_IDS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};

    public MaidMainContainer(class_3917<?> type, int id, class_1661 inventory, int entityId) {
        super(type, id, inventory, entityId);
        if (this.maid != null) {
            this.addMaidHandInv();
            this.addMaidArmorInv();
            this.addMaidBauble();
            this.addMainDefaultInv();
            this.addBackpackInv(inventory);
        }
    }

    private void addMaidHandInv() {
        IItemHandler handler = (IItemHandler)InitCapabilities.MAID_HAND.getNullable((Object)this.maid);
        if (handler == null) {
            return;
        }
        this.method_7621(new SlotItemHandler(this, handler, 0, 87, 77){

            @Environment(value=EnvType.CLIENT)
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_MAINHAND_SLOT);
            }
        });
        this.method_7621(new SlotItemHandler(this, handler, 1, 121, 77){

            @Environment(value=EnvType.CLIENT)
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_1723.field_21673);
            }
        });
    }

    private void addMaidArmorInv() {
        IItemHandler handler = (IItemHandler)InitCapabilities.MAID_ARMOR.getNullable((Object)this.maid);
        if (handler != null) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < 2; ++j) {
                    final class_1304 equipmentSlot = SLOT_IDS[2 * i + j];
                    this.method_7621(new SlotItemHandler(handler, 3 - 2 * i - j, 94 + 20 * j, 37 + 20 * i){

                        @Override
                        public int method_7675() {
                            return 1;
                        }

                        @Override
                        public boolean method_7680(@Nonnull class_1799 stack) {
                            return MaidMainContainer.this.maid != null && MaidMainContainer.this.maid.method_32326(stack) == equipmentSlot && stack.method_7909().method_31568();
                        }

                        @Override
                        public boolean method_7674(class_1657 playerIn) {
                            class_1799 itemstack = this.method_7677();
                            boolean curseEnchant = !itemstack.method_7960() && !playerIn.method_7337() && class_1890.method_60138((class_1799)itemstack, (class_6862)class_9636.field_51551);
                            return !curseEnchant && super.method_7674(playerIn);
                        }

                        @Environment(value=EnvType.CLIENT)
                        public Pair<class_2960, class_2960> method_7679() {
                            return Pair.of((Object)class_1723.field_21668, (Object)TEXTURE_EMPTY_SLOTS[equipmentSlot.method_5927()]);
                        }
                    });
                }
            }
        }
    }

    private void addMainDefaultInv() {
        ItemStackHandler inv = this.maid.getMaidInv();
        for (int i = 0; i < 6; ++i) {
            this.method_7621(new SlotItemHandler(inv, i, 143 + 18 * i, 37));
            if (i != 5) continue;
            this.method_7621(new SlotItemHandler(this, inv, i, 143 + 18 * i, 37){

                public Pair<class_2960, class_2960> method_7679() {
                    return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_BACK_SHOW_SLOT);
                }
            });
        }
    }

    protected abstract void addBackpackInv(class_1661 var1);

    private void addMaidBauble() {
        BaubleItemHandler maidBauble = this.maid.getMaidBauble();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.method_7621(new SlotItemHandler(maidBauble, i * 3 + j, 86 + 18 * j, 99 + 18 * i));
            }
        }
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1799 stack1 = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 stack2 = slot.method_7677();
            stack1 = stack2.method_7972();
            if (index < 36 ? !this.method_7616(stack2, 36, this.field_7761.size(), false) : !this.method_7616(stack2, 0, 36, true)) {
                return class_1799.field_8037;
            }
            if (stack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return stack1;
    }
}

