/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.client.gui.item.ServantBellSetScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFoxScroll;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ItemServantBell
extends class_1792 {
    private static final int MIN_USE_DURATION = 20;

    public ItemServantBell() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public static void recordMaidInfo(class_1799 stack, UUID uuid, String tip) {
        if (stack.method_31574(InitItems.SERVANT_BELL)) {
            stack.method_57379(InitDataComponent.SAKUYA_BELL_UUID_TAG, (Object)uuid);
            stack.method_57379(InitDataComponent.SAKUYA_BELL_TIP_TAG, (Object)tip);
        }
    }

    @Nullable
    public static ItemFoxScroll.TrackInfo getMaidShow(class_1799 stack) {
        return (ItemFoxScroll.TrackInfo)stack.method_57824(InitDataComponent.SAKUYA_BELL_SHOW_TAG);
    }

    public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 target, class_1268 usedHand) {
        EntityMaid maid;
        if (usedHand == class_1268.field_5808 && target instanceof EntityMaid && (maid = (EntityMaid)target).method_6171((class_1309)player)) {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                this.openServantBellSetScreen(maid);
            }
            return class_1269.field_5812;
        }
        return super.method_7847(stack, player, target, usedHand);
    }

    public class_1271<class_1799> method_7836(class_1937 worldIn, class_1657 playerIn, class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        UUID searchUuid = this.getMaidUuid(stack);
        if (searchUuid != null) {
            playerIn.method_6019(handIn);
            return class_1271.method_22428((Object)stack);
        }
        if (!worldIn.field_9236) {
            playerIn.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.servant_bell.data_is_empty"));
        }
        return super.method_7836(worldIn, playerIn, handIn);
    }

    public void method_7840(class_1799 stack, class_1937 worldIn, class_1309 entityLiving, int timeLeft) {
        class_1657 player;
        block9: {
            block8: {
                if (!(entityLiving instanceof class_1657)) break block8;
                player = (class_1657)entityLiving;
                if (timeLeft >= 20) break block9;
            }
            return;
        }
        UUID searchUuid = this.getMaidUuid(stack);
        if (searchUuid == null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.servant_bell.data_is_empty"));
            return;
        }
        if (worldIn instanceof class_3218) {
            class_3218 serverLevel = (class_3218)worldIn;
            List maids = serverLevel.method_18198(EntityMaid.TYPE, maid -> this.checkMaidUuid(player, (EntityMaid)maid, searchUuid));
            if (maids.isEmpty()) {
                this.showMaidInfo(worldIn, player, stack, searchUuid);
            } else {
                stack.method_57381(InitDataComponent.SAKUYA_BELL_SHOW_TAG);
                this.teleportMaid(player, maids);
            }
        }
        worldIn.method_8396(null, player.method_24515(), class_3417.field_17265, class_3419.field_15245, 2.0f, 1.0f);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            InitTrigger.MAID_EVENT.trigger(serverPlayer, "use_servant_bell");
        }
        player.method_7357().method_7906((class_1792)this, 20);
    }

    @Nullable
    private UUID getMaidUuid(class_1799 stack) {
        return (UUID)stack.method_57824(InitDataComponent.SAKUYA_BELL_UUID_TAG);
    }

    private void teleportMaid(class_1657 player, List<? extends EntityMaid> maids) {
        maids.forEach(maid -> {
            maid.setHomeModeEnable(false);
            maid.method_6092(new class_1293(class_1294.field_5912, 200, 1, true, false));
            maid.method_5859(player.method_23317() + (double)player.method_59922().method_43048(3) - 1.0, player.method_23318(), player.method_23321() + (double)player.method_59922().method_43048(3) - 1.0);
        });
    }

    private void showMaidInfo(class_1937 worldIn, class_1657 player, class_1799 stack, UUID searchUuid) {
        MaidWorldData data = MaidWorldData.get(worldIn);
        if (data == null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.servant_bell.no_result"));
            return;
        }
        List<MaidInfo> infos = data.getPlayerMaidInfos(player);
        if (infos == null || infos.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.servant_bell.no_result"));
            return;
        }
        infos.stream().filter(info -> info.getEntityId().equals(searchUuid)).findFirst().ifPresentOrElse(info -> {
            String dimension = info.getDimension();
            String playerDimension = player.field_6002.method_27983().method_29177().toString();
            stack.method_57379(InitDataComponent.SAKUYA_BELL_SHOW_TAG, (Object)new ItemFoxScroll.TrackInfo(dimension, info.getChunkPos()));
            if (dimension.equals(playerDimension)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.servant_bell.show_pos"));
            } else {
                player.method_43496((class_2561)class_2561.method_43469((String)"message.touhou_little_maid.servant_bell.not_same_dimension", (Object[])new Object[]{dimension}));
            }
        }, () -> player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.servant_bell.no_result")));
    }

    private boolean checkMaidUuid(class_1657 player, EntityMaid maid, UUID searchUuid) {
        return maid.method_6171((class_1309)player) && maid.method_5667().equals(searchUuid);
    }

    @Environment(value=EnvType.CLIENT)
    private void openServantBellSetScreen(EntityMaid maid) {
        if (maid.field_6002.field_9236) {
            class_310.method_1551().method_1507((class_437)new ServantBellSetScreen(maid));
        }
    }

    public int method_7881(class_1799 stack, class_1309 livingEntity) {
        return 100;
    }

    public class_1839 method_7853(class_1799 pStack) {
        return class_1839.field_8949;
    }

    public class_2561 method_7864(class_1799 stack) {
        String tip = (String)stack.method_57824(InitDataComponent.SAKUYA_BELL_TIP_TAG);
        if (tip != null) {
            return class_2561.method_43470((String)tip).method_27692(class_124.field_1065).method_27692(class_124.field_1073);
        }
        return super.method_7864(stack);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flagIn) {
        UUID uuid = this.getMaidUuid(stack);
        if (uuid != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltips.touhou_little_maid.servant_bell.uuid", (Object[])new Object[]{uuid.toString()}).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_5244.method_48320());
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.servant_bell.desc.1").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltips.touhou_little_maid.servant_bell.desc.2").method_27692(class_124.field_1080));
    }
}

