/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.parser.ast;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExpressionVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class DoubleExpression
implements Expression {
    public static final DoubleExpression ZERO = new DoubleExpression(0.0);
    public static final DoubleExpression ONE = new DoubleExpression(1.0);
    private final double value;

    public DoubleExpression(double value) {
        this.value = value;
    }

    public double value() {
        return this.value;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitDouble(this);
    }

    public String toString() {
        return "Double(" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleExpression that = (DoubleExpression)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

