/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Search;
import com.github.tartaricacid.touhoulittlemaid.network.message.WChessToServerPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record WChessToClientPackage(class_2338 pos, String fenData) implements class_8710
{
    public static final class_8710.class_9154<WChessToClientPackage> TYPE = new class_8710.class_9154(ResourceLocationUtil.getResourceLocation("wchess_to_client"));
    public static final class_9139<ByteBuf, WChessToClientPackage> STREAM_CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, WChessToClientPackage::pos, (class_9139)class_9135.field_48554, WChessToClientPackage::fenData, WChessToClientPackage::new);

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(WChessToClientPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> CompletableFuture.runAsync(() -> WChessToClientPackage.onHandle(message), class_156.method_18349()));
    }

    @Environment(value=EnvType.CLIENT)
    private static void onHandle(WChessToClientPackage message) {
        int levelTime = 1000;
        long timeStart = System.currentTimeMillis();
        int move = 0;
        Position position = new Position();
        position.fromFen(message.fenData);
        boolean maidLost = WChessUtil.isMaid(position) && position.isMate();
        boolean playerLost = false;
        if (!maidLost) {
            move = new Search(position, 12).searchMain(levelTime);
            playerLost = position.makeMove(move) && WChessUtil.isPlayer(position) && position.isMate();
        }
        long timeRemain = Math.max(0, levelTime - (int)(System.currentTimeMillis() - timeStart));
        try {
            if (timeRemain > 0L) {
                Thread.sleep(timeRemain);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int moveFinal = move;
        boolean playerLostFinal = playerLost;
        class_310.method_1551().method_5382(() -> ClientPlayNetworking.send((class_8710)new WChessToServerPackage(message.pos, moveFinal, maidLost, playerLostFinal)));
    }
}

