/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.client.RenderMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.client.animation.HardcodedAnimationManger;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.ChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.EntityGraphics;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBackItem;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBanner;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBipedHead;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidHeldItem;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.MaidModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.patpat.PatPatCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.ysm.YsmCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.GeoLayerRenderer;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.IGeoEntityRenderer;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import net.minecraft.class_927;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EntityMaidRenderer
extends class_927<class_1308, BedrockModel<class_1308>> {
    private static final class_2960 DEFAULT_TEXTURE = new class_2960("touhou_little_maid", "textures/entity/empty.png");
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    @Nullable
    public static Function<class_5617.class_5618, IGeoEntityRenderer<class_1308>> YSM_ENTITY_MAID_RENDERER;
    private final GeckoEntityMaidRenderer geckoEntityMaidRenderer;
    @Nullable
    private IGeoEntityRenderer<class_1308> ysmMaidRenderer;
    private ChatBubbleRenderer chatBubbleRenderer2;
    private MaidModelInfo mainInfo;
    private List<Object> mainAnimations = Lists.newArrayList();

    public EntityMaidRenderer(class_5617.class_5618 manager) {
        super(manager, new BedrockModel(), 0.5f);
        this.method_4046(new LayerMaidHeldItem(this, manager.method_43338()));
        this.method_4046(new LayerMaidBipedHead(this, manager.method_32170()));
        this.method_4046(new LayerMaidBackpack(this, manager.method_32170()));
        this.method_4046(new LayerMaidBackItem(this));
        this.method_4046(new LayerMaidBanner(this, manager.method_32170()));
        this.addAdditionMaidLayer(manager);
        this.geckoEntityMaidRenderer = new GeckoEntityMaidRenderer(manager);
        this.initYsmModelRenderer(manager);
        this.chatBubbleRenderer2 = new ChatBubbleRenderer(this);
    }

    private void initYsmModelRenderer(class_5617.class_5618 manager) {
        if (!YsmCompat.isInstalled() || YSM_ENTITY_MAID_RENDERER == null) {
            return;
        }
        IGeoEntityRenderer<class_1308> geoEntityRenderer = YSM_ENTITY_MAID_RENDERER.apply(manager);
        if (geoEntityRenderer != null) {
            this.ysmMaidRenderer = geoEntityRenderer;
            List<GeoLayerRenderer> layerRenderers = this.geckoEntityMaidRenderer.getLayerRenderers();
            for (GeoLayerRenderer layerRenderer : layerRenderers) {
                this.ysmMaidRenderer.addGeoLayerRenderer(layerRenderer.copy(this.ysmMaidRenderer));
            }
        }
    }

    public void method_4072(class_1308 entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        IMaid maid = IMaid.convert(entity);
        if (maid == null) {
            return;
        }
        if (SWarfareCompat.shouldHideLivingRender((class_1309)entity)) {
            return;
        }
        CustomPackLoader.MAID_MODELS.getModel(DEFAULT_MODEL_ID).ifPresent(model -> {
            this.field_4737 = model;
        });
        CustomPackLoader.MAID_MODELS.getInfo(DEFAULT_MODEL_ID).ifPresent(info -> {
            this.mainInfo = info;
        });
        CustomPackLoader.MAID_MODELS.getAnimation(DEFAULT_MODEL_ID).ifPresent(animations -> {
            this.mainAnimations = animations;
        });
        MaidModels.ModelData eventModelData = new MaidModels.ModelData((BedrockModel)this.field_4737, this.mainInfo, this.mainAnimations);
        RenderMaidEvent event = new RenderMaidEvent(maid, eventModelData);
        ((RenderMaidEvent.Callback)RenderMaidEvent.CALLBACK.invoker()).post(event);
        if (event.isCanceled()) {
            BedrockModel<class_1308> bedrockModel = eventModelData.getModel();
            if (bedrockModel != null) {
                this.field_4737 = bedrockModel;
            }
            this.mainInfo = eventModelData.getInfo();
            this.mainAnimations = eventModelData.getAnimations();
        } else {
            CustomPackLoader.MAID_MODELS.getModel(maid.getModelId()).ifPresent(model -> {
                this.field_4737 = model;
            });
            CustomPackLoader.MAID_MODELS.getInfo(maid.getModelId()).ifPresent(info -> {
                this.mainInfo = info;
            });
            CustomPackLoader.MAID_MODELS.getAnimation(maid.getModelId()).ifPresent(animations -> {
                this.mainAnimations = animations;
            });
        }
        EntityMaid maidEntity = maid.asStrictMaid();
        if (maidEntity != null && ((Boolean)MaidConfig.GLOBAL_MAID_SHOW_CHAT_BUBBLE.get()).booleanValue() && maidEntity.getConfigManager().isChatBubbleShow()) {
            poseStack.method_22903();
            float offsetY = maidEntity.method_51152();
            if (maidEntity.isMaidInSittingPose()) {
                offsetY -= 0.25f;
            }
            poseStack.method_46416(0.0f, offsetY, 0.0f);
            poseStack.method_22907(this.field_4676.method_24197());
            poseStack.method_22905(-0.025f, -0.025f, 0.025f);
            EntityGraphics graphics = new EntityGraphics(bufferIn, poseStack, maidEntity, packedLightIn, partialTicks);
            this.chatBubbleRenderer2.render(graphics);
            poseStack.method_22909();
        }
        if (maid.isYsmModel() && this.ysmMaidRenderer != null) {
            IGeoEntity geoEntity = this.ysmMaidRenderer.getGeoEntity(entity);
            geoEntity.setYsmModel(maid.getYsmModelId(), maid.getYsmModelTexture());
            if (maidEntity != null) {
                geoEntity.updateRoamingVars(maidEntity.roamingVars);
            }
            PatPatCompat.renderPat((class_1309)entity, poseStack, partialTicks);
            this.ysmMaidRenderer.geoRender(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            return;
        }
        if (this.mainInfo.isGeckoModel()) {
            this.geckoEntityMaidRenderer.getAnimatableEntity(entity).setMaidInfo(this.mainInfo);
            PatPatCompat.renderPat((class_1309)entity, poseStack, partialTicks);
            this.geckoEntityMaidRenderer.render(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            return;
        }
        ((BedrockModel)this.field_4737).setAnimations(this.mainAnimations);
        GlWrapper.setPoseStack(poseStack);
        super.method_4072(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        GlWrapper.clearPoseStack();
    }

    protected void scale(class_1308 maid, class_4587 poseStack, float partialTickTime) {
        float scale = this.mainInfo.getRenderEntityScale();
        poseStack.method_22905(scale, scale, scale);
    }

    protected void setupRotations(class_1308 mob, class_4587 poseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.method_4058((class_1309)mob, poseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        if (mob.method_5854() instanceof class_1657 && !this.mainInfo.isGeckoModel()) {
            poseStack.method_22904(-0.375, 0.8325, 0.375);
            poseStack.method_22907(class_7833.field_40717.rotationDegrees(65.0f));
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(-80.0f));
        }
        HardcodedAnimationManger.setupRotations(mob, poseStack, pAgeInTicks, pRotationYaw, pPartialTicks, this.mainInfo.isGeckoModel());
    }

    public class_2960 getTextureLocation(class_1308 maid) {
        if (this.mainInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return this.mainInfo.getTexture();
    }

    public MaidModelInfo getMainInfo() {
        return this.mainInfo;
    }

    public class_898 getDispatcher() {
        return this.field_4676;
    }

    private void addAdditionMaidLayer(class_5617.class_5618 renderManager) {
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addAdditionMaidLayer(this, renderManager);
        }
    }
}

