/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.item.ItemCamera;
import com.github.tartaricacid.touhoulittlemaid.world.backups.MaidBackupsManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class BackupCommand {
    private static final String BACKUP_NAME = "backup";
    private static final String GET_NAME = "get";
    private static final String PLAYER_NAME = "player";
    private static final String MAID_UUID = "maid_uuid";
    private static final String FILE_NAME = "file_name";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder root = class_2170.method_9247((String)BACKUP_NAME);
        LiteralArgumentBuilder get = class_2170.method_9247((String)GET_NAME);
        RequiredArgumentBuilder player = class_2170.method_9244((String)PLAYER_NAME, (ArgumentType)class_2186.method_9305());
        RequiredArgumentBuilder maidUuid = class_2170.method_9244((String)MAID_UUID, (ArgumentType)class_5242.method_27643());
        RequiredArgumentBuilder fileName = class_2170.method_9244((String)FILE_NAME, (ArgumentType)StringArgumentType.string());
        root.then(get.then(player.executes(BackupCommand::handlePlayerMaidIndex)));
        root.then(get.then(player.then(maidUuid.executes(BackupCommand::handlePlayerMaid))));
        root.then(get.then(player.then(maidUuid.then(fileName.executes(BackupCommand::handlePlayerMaidFile)))));
        return root;
    }

    private static String getFormattedTime(long timestamp) {
        LocalDateTime dateTime = LocalDateTime.ofEpochSecond(timestamp / 1000L, 0, ZoneOffset.UTC);
        return dateTime.format(DateTimeFormatter.ofPattern("(MM/dd HH:mm)"));
    }

    private static int handlePlayerMaidIndex(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)PLAYER_NAME);
        Map maidIndexMap = MaidBackupsManager.getMaidIndexMap(player);
        if (maidIndexMap.isEmpty()) {
            class_5250 error = class_2561.method_43469((String)"message.touhou_little_maid.maid_backup.player.no_data", (Object[])new Object[]{player.method_5820()});
            player.method_43496((class_2561)error.method_27692(class_124.field_1061));
            return 1;
        }
        maidIndexMap = maidIndexMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingLong(MaidBackupsManager.IndexData::timestamp).reversed())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        class_5250 separator = class_2561.method_43469((String)"message.touhou_little_maid.maid_backup.player.separator", (Object[])new Object[]{player.method_5820()});
        player.method_43496((class_2561)separator.method_27692(class_124.field_1077));
        int index = 1;
        for (Map.Entry entry : maidIndexMap.entrySet()) {
            UUID id = (UUID)entry.getKey();
            MaidBackupsManager.IndexData data = (MaidBackupsManager.IndexData)entry.getValue();
            String time = "\u00a77" + BackupCommand.getFormattedTime(data.timestamp());
            class_5250 msg = class_2561.method_43470((String)"\u00a77%d.".formatted(index)).method_10852(class_5244.field_41874).method_10852(data.name()).method_27692(class_124.field_1065).method_10852(class_5244.field_41874).method_27693(time);
            class_5250 dimension = class_2561.method_43469((String)"tooltips.touhou_little_maid.fox_scroll.dimension", (Object[])new Object[]{data.dimension()});
            class_5250 pos = class_2561.method_43469((String)"tooltips.touhou_little_maid.fox_scroll.position", (Object[])new Object[]{data.pos().method_23854()});
            String command = "/tlm backup get @s %s".formatted(id);
            class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24342, (Object)class_5244.method_37110((class_2561[])new class_2561[]{dimension, pos}));
            class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11750, command);
            msg.method_27694(style -> style.method_10949(hoverEvent)).method_27694(style -> style.method_10958(clickEvent));
            player.method_43496((class_2561)msg);
            ++index;
        }
        return 1;
    }

    private static int handlePlayerMaid(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)PLAYER_NAME);
        UUID uuid = class_5242.method_27645(context, (String)MAID_UUID);
        Map<UUID, MaidBackupsManager.IndexData> maidIndexMap = MaidBackupsManager.getMaidIndexMap(player);
        MaidBackupsManager.IndexData indexData = maidIndexMap.get(uuid);
        if (indexData == null) {
            class_5250 error = class_2561.method_43469((String)"message.touhou_little_maid.maid_backup.maid.not_found", (Object[])new Object[]{uuid});
            player.method_43496((class_2561)error.method_27692(class_124.field_1061));
            return 1;
        }
        class_5250 separator = class_2561.method_43469((String)"message.touhou_little_maid.maid_backup.maid.separator", (Object[])new Object[]{indexData.name()});
        player.method_43496((class_2561)separator.method_27692(class_124.field_1077));
        List<String> backupFiles = MaidBackupsManager.getMaidBackupFiles(player, uuid);
        for (String backupFile : backupFiles) {
            class_5250 msg = class_2561.method_43470((String)backupFile).method_27692(class_124.field_1064);
            String command = "/tlm backup get @s %s \"%s\"".formatted(uuid, backupFile);
            class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11750, command);
            msg.method_27694(style -> style.method_10958(clickEvent));
            player.method_43496((class_2561)msg);
        }
        return 1;
    }

    private static int handlePlayerMaidFile(CommandContext<class_2168> context) throws CommandSyntaxException {
        String fileName;
        UUID uuid;
        class_3222 player = class_2186.method_9315(context, (String)PLAYER_NAME);
        class_2487 backupData = MaidBackupsManager.getMaidBackFile(player, uuid = class_5242.method_27645(context, (String)MAID_UUID), fileName = StringArgumentType.getString(context, (String)FILE_NAME));
        if (backupData.method_33133()) {
            class_5250 error = class_2561.method_43469((String)"message.touhou_little_maid.maid_backup.file.not_found", (Object[])new Object[]{fileName});
            player.method_43496((class_2561)error.method_27692(class_124.field_1061));
            return 1;
        }
        ItemCamera.spawnMaidPhoto(player.field_6002, backupData, (class_1657)player);
        class_5250 success = class_2561.method_43469((String)"message.touhou_little_maid.maid_backup.file.success", (Object[])new Object[]{fileName});
        player.method_43496((class_2561)success.method_27692(class_124.field_1060));
        return 1;
    }
}

