/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import cn.sh1rocu.touhoulittlemaid.util.forge.RecipeMatcher;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.inventory.AltarRecipeInventory;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3956;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;

public class AltarRecipe
implements class_1860<AltarRecipeInventory> {
    private final class_2960 id;
    private final class_1299<?> entityType;
    @Nullable
    private final class_2487 extraData;
    private final float powerCost;
    private final class_2371<class_1856> inputs;
    private final boolean isItemCraft;
    private final class_1799 resultItem;
    private final class_1856 copyInput;
    @Nullable
    private final String copyTag;

    public AltarRecipe(class_2960 id, class_1299<?> entityType, @Nullable class_2487 extraData, float powerCost, class_1856 copyInput, @Nullable String copyTag, class_1856 ... inputs) {
        Preconditions.checkArgument((0 < inputs.length && inputs.length <= 6 ? 1 : 0) != 0, (Object)"Ingredients count is illegal!");
        this.id = id;
        this.entityType = entityType;
        this.isItemCraft = entityType == class_1299.field_6052;
        this.resultItem = this.isItemCraft && extraData != null ? class_1799.method_7915((class_2487)extraData.method_10562("Item")) : class_1799.field_8037;
        this.copyInput = copyInput;
        this.copyTag = copyTag;
        this.extraData = extraData;
        this.powerCost = powerCost;
        this.inputs = class_2371.method_10212((Object)class_1856.field_9017, (Object[])this.fillInputs(inputs));
    }

    public AltarRecipe(class_2960 id, class_1299<?> entityType, @Nullable class_2487 extraData, float powerCost, class_1856 ... inputs) {
        this(id, entityType, extraData, powerCost, class_1856.field_9017, (String)null, inputs);
    }

    public boolean matches(AltarRecipeInventory inv, class_1937 worldIn) {
        return RecipeMatcher.findMatches(inv.getItems(), this.inputs) != null;
    }

    public class_1799 assemble(AltarRecipeInventory inv, class_5455 access) {
        return this.method_8110(access).method_7972();
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public class_1799 method_8110(class_5455 access) {
        return this.resultItem;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return InitRecipes.ALTAR_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return InitRecipes.ALTAR_CRAFTING;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1799 method_17447() {
        return InitItems.HAKUREI_GOHEI.method_7854();
    }

    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    @Nullable
    public class_2487 getExtraData() {
        return this.extraData;
    }

    public float getPowerCost() {
        return this.powerCost;
    }

    public class_1856 getCopyInput() {
        return this.copyInput;
    }

    @Nullable
    public String getCopyTag() {
        return this.copyTag;
    }

    public void spawnOutputEntity(class_3218 world, class_2338 pos, @Nullable AltarRecipeInventory inventory) {
        if (this.extraData != null) {
            class_2487 nbt = this.extraData.method_10553();
            nbt.method_10582("id", Objects.requireNonNull(class_7923.field_41177.method_10221(this.entityType)).toString());
            class_1297 resultEntity = class_1299.method_17842((class_2487)nbt, (class_1937)world, e -> {
                e.method_5808((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), e.method_36454(), e.method_36455());
                this.finalizeSpawn(world, pos, (class_1297)e);
                return e;
            });
            if (resultEntity != null) {
                this.finalizeSpawn(world, pos, resultEntity);
                this.copyIngredientTag(inventory, resultEntity);
                world.method_30736(resultEntity);
            }
            return;
        }
        this.entityType.method_5894(world, null, (class_1657)null, pos, class_3730.field_16465, true, true);
    }

    private void copyIngredientTag(@Nullable AltarRecipeInventory inventory, class_1297 resultEntity) {
        class_2487 data;
        class_1799 matchStack;
        if (inventory != null && this.copyInput != class_1856.field_9017 && !(matchStack = inventory.getMatchIngredient(this.copyInput)).method_7960() && (data = StringUtils.isEmpty((CharSequence)this.copyTag) ? matchStack.method_7969() : matchStack.method_7941(this.copyTag)) != null && !data.method_33133()) {
            if (resultEntity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)resultEntity;
                livingEntity.method_5749(data);
            }
            if (resultEntity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)resultEntity;
                itemEntity.method_5749(data);
            }
        }
    }

    public boolean isItemCraft() {
        return this.isItemCraft;
    }

    private void finalizeSpawn(class_3218 world, class_2338 pos, @Nullable class_1297 entity) {
        if (entity instanceof class_1308) {
            ((class_1308)entity).method_5943((class_5425)world, world.method_8404(pos), class_3730.field_16465, null, null);
        }
    }

    private class_1856[] fillInputs(class_1856[] inputs) {
        class_1856[] newInputs = new class_1856[6];
        for (int i = 0; i < 6; ++i) {
            newInputs[i] = i < inputs.length ? inputs[i] : class_1856.field_9017;
        }
        return newInputs;
    }
}

