/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import cn.sh1rocu.touhoulittlemaid.api.extension.IEntityAdditionalSpawnData;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_1538;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;

public class EntityTombstone
extends class_1297 {
    public static final class_1299<EntityTombstone> TYPE = class_1299.class_1300.method_5903(EntityTombstone::new, (class_1311)class_1311.field_17715).method_17687(0.8f, 1.2f).method_27299(10).method_5905("tombstone");
    private static final String OWNER_ID_TAG = "OwnerId";
    private static final String TOMBSTONE_ITEMS_TAG = "TombstoneItems";
    private static final String MAID_NAME_TAG = "MaidName";
    private static final class_2940<class_2561> MAID_NAME = class_2945.method_12791(EntityTombstone.class, (class_2941)class_2943.field_13317);
    private final ItemStackHandler items = new ItemStackHandler(108);
    private UUID ownerId = class_156.field_25140;

    public EntityTombstone(class_1299<?> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityTombstone(class_1937 worldIn, UUID ownerId, class_243 pos) {
        this(TYPE, worldIn);
        this.ownerId = ownerId;
        this.method_33574(pos);
    }

    public void insertItem(class_1799 item) {
        ItemHandlerHelper.insertItemStacked(this.items, item, false);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 itemInHand = player.method_5998(hand);
        class_1856 ntrItem = EntityMaid.getNtrItem();
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        if (player.method_5667().equals(this.ownerId) || ntrItem.method_8093(itemInHand)) {
            int i;
            if (!player.method_21823()) {
                for (i = 0; i < this.items.getSlots(); ++i) {
                    class_1799 stack = this.items.getStackInSlot(i);
                    if (stack.method_7960() || ItemsUtil.canItemInsert(player, stack)) continue;
                    if (!player.field_6002.field_9236) {
                        player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.tombstone.player_inventory_full.1"));
                        player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.tombstone.player_inventory_full.2"));
                    }
                    return class_1269.field_5814;
                }
            }
            for (i = 0; i < this.items.getSlots(); ++i) {
                int size = this.items.getSlotLimit(i);
                class_1799 extractItem = this.items.extractItem(i, size, false);
                if (extractItem.method_7960()) continue;
                ItemHandlerHelper.giveItemToPlayer(player, extractItem);
            }
            this.method_31472();
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (!player.field_6002.field_9236) {
            class_1799 stack = Arrays.stream(ntrItem.method_8105()).findFirst().orElse(class_1799.field_8037);
            class_2561 displayName = stack.method_7954();
            player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.tombstone.not_yours.1"));
            player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.tombstone.not_yours.2").method_10852(displayName));
        }
        return super.method_5688(player, hand);
    }

    protected void method_5693() {
        this.field_6011.method_12784(MAID_NAME, (Object)class_2561.method_43473());
    }

    protected void method_5749(class_2487 tag) {
        if (tag.method_10545(OWNER_ID_TAG)) {
            this.ownerId = tag.method_25926(OWNER_ID_TAG);
        }
        if (tag.method_10545(TOMBSTONE_ITEMS_TAG)) {
            this.items.deserializeNBT(tag.method_10562(TOMBSTONE_ITEMS_TAG));
        }
        if (tag.method_10545(MAID_NAME_TAG)) {
            String nameJson = tag.method_10558(MAID_NAME_TAG);
            this.setMaidName((class_2561)class_2561.class_2562.method_10877((String)nameJson));
        }
    }

    protected void method_5652(class_2487 tag) {
        tag.method_25927(OWNER_ID_TAG, this.ownerId);
        tag.method_10566(TOMBSTONE_ITEMS_TAG, (class_2520)this.items.serializeNBT());
        tag.method_10582(MAID_NAME_TAG, class_2561.class_2562.method_10867((class_2561)this.getMaidName()));
    }

    public void method_5773() {
        if (!this.field_6002.field_9236) {
            this.method_31473();
        }
    }

    public boolean method_5698(class_1297 pEntity) {
        return true;
    }

    public boolean method_5643(class_1282 pSource, float pAmount) {
        return false;
    }

    public void method_5784(class_1313 pType, class_243 pPos) {
    }

    public void method_5697(class_1297 entity) {
    }

    public void method_5762(double pX, double pY, double pZ) {
    }

    protected boolean method_5638() {
        return false;
    }

    public void method_5800(class_3218 pLevel, class_1538 pLightning) {
    }

    public void method_18382() {
    }

    public void method_5650(class_1297.class_5529 reason) {
        MaidWorldData maidWorldData;
        if (reason.method_31486() && (maidWorldData = MaidWorldData.get(this.field_6002)) != null) {
            maidWorldData.removeTombstones(this);
        }
        super.method_5650(reason);
    }

    public boolean method_30949(class_1297 entity) {
        return false;
    }

    public boolean method_5863() {
        return this.method_5805();
    }

    public class_2596<class_2602> method_18002() {
        return IEntityAdditionalSpawnData.getEntitySpawningPacket(this);
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public void setMaidName(@Nullable class_2561 name) {
        if (name != null) {
            this.field_6011.method_12778(MAID_NAME, (Object)name);
        }
    }

    public class_2561 getMaidName() {
        return (class_2561)this.field_6011.method_12789(MAID_NAME);
    }

    public ItemStackHandler getItems() {
        return this.items;
    }
}

