/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.world.backups;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.DimensionDataStorageAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.config.ServerConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaidBackupsManager {
    private static final String BACKUPS_FOLDER_NAME = "maid_backups";
    private static final String INDEX_FILE_NAME = "index.dat";
    private static final String BACKUP_FILE_EXTENSION = ".dat";
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "Maid-Backups-Thread");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, e) -> TouhouLittleMaid.LOGGER.error("Uncaught exception in maid backup thread: {}", (Object)t.getName(), (Object)e));
        return thread;
    });
    private static final DateTimeFormatter BACKUP_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");

    private MaidBackupsManager() {
    }

    public static void save(@NotNull MinecraftServer server, @NotNull EntityMaid maid) {
        UUID ownerId = maid.method_6139();
        if (ownerId == null) {
            TouhouLittleMaid.LOGGER.debug("Skipping backup for maid {} - no owner", (Object)maid.method_5845());
            return;
        }
        class_3218 overWorld = server.method_3847(class_1937.field_25179);
        if (overWorld == null) {
            TouhouLittleMaid.LOGGER.error("Cannot access overworld for maid backup: {}", (Object)maid.method_5845());
            return;
        }
        try {
            BackupData backupData = MaidBackupsManager.createBackupData(maid, overWorld, ownerId);
            if (backupData != null) {
                MaidBackupsManager.executeBackupAsync(backupData);
            }
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to initiate backup for maid: {}", (Object)maid.method_5845(), (Object)e);
        }
    }

    public static class_2487 getMaidIndex(class_3222 player) {
        UUID ownerId = player.method_5667();
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return new class_2487();
        }
        class_3218 overWorld = server.method_3847(class_1937.field_25179);
        if (overWorld == null) {
            TouhouLittleMaid.LOGGER.error("Cannot access overworld for maid index retrieval: {}", (Object)ownerId);
            return new class_2487();
        }
        Path ownerFolder = ((DimensionDataStorageAccessor)overWorld.method_17983()).tlm$getDataFolder().toPath().resolve(BACKUPS_FOLDER_NAME).resolve(ownerId.toString());
        File indexFile = ownerFolder.resolve(INDEX_FILE_NAME).toFile();
        return MaidBackupsManager.loadExistingIndexData(indexFile);
    }

    @Nullable
    private static BackupData createBackupData(@NotNull EntityMaid maid, @NotNull class_3218 overWorld, @NotNull UUID ownerId) {
        try {
            Path saveFolder = MaidBackupsManager.buildBackupFolderPath(maid, overWorld, ownerId);
            String saveFileName = MaidBackupsManager.generateBackupFileName();
            class_2487 entityData = new class_2487();
            boolean saveResult = maid.method_5786(entityData);
            if (!saveResult) {
                TouhouLittleMaid.LOGGER.warn("Failed to serialize maid data for backup: {}", (Object)maid.method_5845());
                return null;
            }
            class_2487 indexData = MaidBackupsManager.createIndexData(maid);
            return new BackupData(saveFolder, saveFileName, entityData, indexData, maid.method_5845());
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Error creating backup data for maid: {}", (Object)maid.method_5845(), (Object)e);
            return null;
        }
    }

    @NotNull
    private static class_2487 createIndexData(@NotNull EntityMaid maid) {
        class_2487 indexData = new class_2487();
        indexData.method_10582("Name", class_2561.class_2562.method_10867((class_2561)maid.method_5477()));
        indexData.method_10582("Dimension", maid.field_6002.method_27983().method_29177().toString());
        indexData.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)maid.method_24515()));
        indexData.method_10544("Timestamp", System.currentTimeMillis());
        return indexData;
    }

    public static Map<UUID, IndexData> getMaidIndexMap(class_3222 player) {
        class_2487 indexTag = MaidBackupsManager.getMaidIndex(player);
        HashMap map = Maps.newHashMap();
        for (String s : indexTag.method_10541()) {
            class_2487 maidTag = indexTag.method_10562(s);
            UUID maidUuid = UUID.fromString(s);
            class_5250 name = class_2561.class_2562.method_10877((String)maidTag.method_10558("Name"));
            class_2338 pos = class_2512.method_10691((class_2487)maidTag.method_10562("Pos"));
            String dimension = maidTag.method_10558("Dimension");
            long timestamp = maidTag.method_10537("Timestamp");
            map.put(maidUuid, new IndexData((class_2561)name, pos, dimension, timestamp));
        }
        return map;
    }

    public static List<String> getMaidBackupFiles(class_3222 player, UUID maidUuid) {
        ArrayList backupFiles = Lists.newArrayList();
        Path folderPath = ((DimensionDataStorageAccessor)player.method_51469().method_17983()).tlm$getDataFolder().toPath().resolve(BACKUPS_FOLDER_NAME).resolve(player.method_5667().toString()).resolve(maidUuid.toString());
        if (!Files.isDirectory(folderPath, new LinkOption[0])) {
            return backupFiles;
        }
        File[] files = folderPath.toFile().listFiles((dir, name) -> name.endsWith(BACKUP_FILE_EXTENSION));
        if (files == null) {
            return backupFiles;
        }
        for (File file : files) {
            backupFiles.add(file.getName());
        }
        backupFiles.sort(Comparator.reverseOrder());
        return backupFiles;
    }

    public static class_2487 getMaidBackFile(class_3222 player, UUID maidUuid, String fileName) {
        Path filePath = ((DimensionDataStorageAccessor)player.method_51469().method_17983()).tlm$getDataFolder().toPath().resolve(BACKUPS_FOLDER_NAME).resolve(player.method_5667().toString()).resolve(maidUuid.toString()).resolve(fileName);
        File file = filePath.toFile();
        if (!file.exists() || !file.isFile()) {
            return new class_2487();
        }
        try {
            return class_2507.method_30613((File)file);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to read maid backup file: {}", (Object)filePath, (Object)e);
            return new class_2487();
        }
    }

    private static void executeBackupAsync(@NotNull BackupData backupData) {
        CompletableFuture.runAsync(() -> MaidBackupsManager.performBackup(backupData), EXECUTOR_SERVICE).exceptionally(error -> {
            TouhouLittleMaid.LOGGER.error("Async backup failed for maid: {}", (Object)backupData.maidUuid, error);
            return null;
        });
    }

    private static void performBackup(@NotNull BackupData backupData) {
        try {
            if (!MaidBackupsManager.ensureDirectoryExists(backupData.saveFolder)) {
                return;
            }
            if (!MaidBackupsManager.updateIndexFile(backupData)) {
                return;
            }
            MaidBackupsManager.saveEntityData(backupData);
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Backup operation failed for maid: {}", (Object)backupData.maidUuid, (Object)e);
        }
    }

    private static boolean ensureDirectoryExists(@NotNull Path directory) {
        if (Files.isDirectory(directory, new LinkOption[0])) {
            return true;
        }
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to create backup directory: {}", (Object)directory, (Object)e);
            return false;
        }
    }

    private static boolean updateIndexFile(@NotNull BackupData backupData) {
        File indexFile = backupData.saveFolder.getParent().resolve(INDEX_FILE_NAME).toFile();
        try {
            class_2487 allIndexData = MaidBackupsManager.loadExistingIndexData(indexFile);
            allIndexData.method_10566(backupData.saveFolder.getFileName().toString(), (class_2520)backupData.indexData);
            class_2507.method_30614((class_2487)allIndexData, (File)indexFile);
            return true;
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to update index file: {}", (Object)indexFile, (Object)e);
            return false;
        }
    }

    @NotNull
    private static class_2487 loadExistingIndexData(@NotNull File indexFile) {
        if (!indexFile.exists()) {
            return new class_2487();
        }
        try {
            return class_2507.method_30613((File)indexFile);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.warn("Failed to read existing index file, creating new one: {}", (Object)indexFile, (Object)e);
            return new class_2487();
        }
    }

    private static void saveEntityData(@NotNull BackupData backupData) {
        File backupFile = backupData.saveFolder.resolve(backupData.saveFileName).toFile();
        try {
            class_2512.method_48310((class_2487)backupData.entityData);
            class_2507.method_30614((class_2487)backupData.entityData, (File)backupFile);
            TouhouLittleMaid.LOGGER.debug("Saved entity data to: {}", (Object)backupFile);
            MaidBackupsManager.removeOldBackups(backupData.saveFolder, (Integer)ServerConfig.MAID_BACKUP_MAX_COUNT.get());
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to save entity data to: {}", (Object)backupFile, (Object)e);
        }
    }

    private static void removeOldBackups(@NotNull Path backupFolder, int maxBackups) {
        try {
            File[] backupFiles = backupFolder.toFile().listFiles((dir, name) -> name.endsWith(BACKUP_FILE_EXTENSION));
            if (backupFiles == null || backupFiles.length <= maxBackups) {
                return;
            }
            Arrays.sort(backupFiles, Comparator.comparing(File::getName));
            for (int i = 0; i < backupFiles.length - maxBackups; ++i) {
                if (backupFiles[i].delete()) {
                    TouhouLittleMaid.LOGGER.debug("Deleted old backup file: {}", (Object)backupFiles[i].getAbsolutePath());
                    continue;
                }
                TouhouLittleMaid.LOGGER.warn("Failed to delete old backup file: {}", (Object)backupFiles[i].getAbsolutePath());
            }
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Error while removing old backups in folder: {}", (Object)backupFolder, (Object)e);
        }
    }

    @NotNull
    private static Path buildBackupFolderPath(@NotNull EntityMaid maid, @NotNull class_3218 level, @NotNull UUID ownerId) {
        return ((DimensionDataStorageAccessor)level.method_17983()).tlm$getDataFolder().toPath().resolve(BACKUPS_FOLDER_NAME).resolve(ownerId.toString()).resolve(maid.method_5845());
    }

    @NotNull
    public static String generateBackupFileName() {
        return LocalDateTime.now().format(BACKUP_TIME_FORMATTER) + BACKUP_FILE_EXTENSION;
    }

    private record BackupData(Path saveFolder, String saveFileName, class_2487 entityData, class_2487 indexData, String maidUuid) {
    }

    public record IndexData(class_2561 name, class_2338 pos, String dimension, long timestamp) {
    }
}

