/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.minecraft.class_6670;
import org.jetbrains.annotations.Nullable;

public class MaidWalkToLivingEntityTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private final Predicate<EntityMaid> startSearchPredicate;
    private final BiPredicate<EntityMaid, class_1309> entityPredicate;
    private final BiConsumer<EntityMaid, class_1309> arriveAction;
    private final float closeEnoughDistance;
    @Nullable
    private class_1309 targetEntity = null;

    public MaidWalkToLivingEntityTask(float speedModifier, float closeEnoughDistance, @Nullable Predicate<EntityMaid> startSearchPredicate, @Nullable BiPredicate<EntityMaid, class_1309> entityPredicate, @Nullable BiConsumer<EntityMaid, class_1309> arriveAction) {
        super((Map<class_4140<?>, class_4141>)ImmutableMap.of((Object)class_4140.field_18442, (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(12);
        this.closeEnoughDistance = closeEnoughDistance;
        this.startSearchPredicate = Objects.requireNonNullElse(startSearchPredicate, maid -> false);
        this.entityPredicate = Objects.requireNonNullElse(entityPredicate, (maid, entity) -> false);
        this.arriveAction = Objects.requireNonNullElse(arriveAction, (maid, entity) -> {});
    }

    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        this.targetEntity = null;
        if (!this.startSearchPredicate.test(maid)) {
            return;
        }
        this.getEntities(maid).method_38980(e -> maid.method_18407(e.method_24515())).filter(class_1297::method_5805).filter(e -> this.entityPredicate.test(maid, (class_1309)e)).filter(maid::canPathReach).findFirst().ifPresent(e -> {
            this.targetEntity = e;
            class_4215.method_24557((class_1309)maid, (class_1297)e, (float)this.speedModifier, (int)((int)Math.max(0.0f, this.closeEnoughDistance - 1.0f)));
        });
        if (this.targetEntity != null && this.targetEntity.method_24516((class_1297)maid, (double)this.closeEnoughDistance)) {
            this.arriveAction.accept(maid, this.targetEntity);
            maid.method_18868().method_18875(class_4140.field_18446);
            maid.method_18868().method_18875(class_4140.field_18445);
            this.targetEntity = null;
        }
    }

    private class_6670 getEntities(EntityMaid maid) {
        return maid.method_18868().method_18904(class_4140.field_18442).orElse(class_6670.method_38971());
    }
}

