/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.backpack.data;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncFluidAmountMessage;
import com.github.tartaricacid.touhoulittlemaid.util.MaidFluidUtil;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.SingleFluidStorage;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class TankBackpackData
extends class_1277
implements IBackpackData {
    public static final long CAPACITY = 810000L;
    private static final int INPUT_INDEX = 0;
    private static final int OUTPUT_INDEX = 1;
    private final EntityMaid maid;
    private final SingleFluidStorage tank = SingleFluidStorage.withFixedCapacity((long)810000L, () -> {});
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            if (index == 0) {
                return (int)TankBackpackData.this.tankFluidCount;
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            if (index == 0) {
                TankBackpackData.this.tankFluidCount = value;
            }
        }

        public int method_17389() {
            return 1;
        }
    };
    private long tankFluidCount = 0L;

    public TankBackpackData(EntityMaid maid) {
        super(2);
        this.maid = maid;
    }

    public void method_5447(int index, @NotNull class_1799 stack) {
        if (!this.maid.field_6002.field_9236) {
            CombinedInvWrapper availableInv = this.maid.getAvailableInv(false);
            if (index == 0) {
                MaidFluidUtil.bucketToTank(stack, this.tank, availableInv);
            }
            if (index == 1) {
                MaidFluidUtil.tankToBucket(stack, this.tank, availableInv);
            }
            this.tankFluidCount = this.tank.amount;
            class_1309 class_13092 = this.maid.method_35057();
            if (class_13092 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_13092;
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)SyncFluidAmountMessage.ID, (class_2540)SyncFluidAmountMessage.encode(this.maid.method_5628(), (int)this.tankFluidCount));
            }
            class_2960 key = class_7923.field_41173.method_10221((Object)((FluidVariant)this.tank.getResource()).getFluid());
            this.maid.setBackpackFluid(key.toString());
        }
        super.method_5447(index, stack);
    }

    public int method_5444() {
        return 1;
    }

    @Override
    public class_3913 getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public void load(class_2487 tag, EntityMaid maid) {
        this.loadTank(tag.method_10562("Tanks"), maid);
        this.method_7659(tag.method_10554("Items", 10));
    }

    @Override
    public void save(class_2487 tag, EntityMaid maid) {
        class_2487 tankNbt = new class_2487();
        this.tank.writeNbt(tankNbt);
        tag.method_10566("Tanks", (class_2520)tankNbt);
        tag.method_10566("Items", (class_2520)this.method_7660());
    }

    @Override
    public void serverTick(EntityMaid maid) {
    }

    public SingleFluidStorage getTank() {
        return this.tank;
    }

    public void loadTank(class_2487 nbt, EntityMaid maid) {
        this.tank.readNbt(nbt);
        this.tankFluidCount = this.tank.getAmount();
        class_2960 key = class_7923.field_41173.method_10221((Object)((FluidVariant)this.tank.getResource()).getFluid());
        maid.setBackpackFluid(key.toString());
    }
}

