/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.site;

import com.github.tartaricacid.touhoulittlemaid.ai.service.SupportModelSelect;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSSite;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2540;
import org.apache.commons.lang3.tuple.Pair;

public class ClientAvailableSitesSync {
    private static final Map<String, Map<String, String>> CLIENT_LLM_SITES = Maps.newLinkedHashMap();
    private static final Map<String, Map<String, String>> CLIENT_TTS_SITES = Maps.newLinkedHashMap();

    public static void init(Map<String, LLMSite> llmSites, Map<String, TTSSite> ttsSites) {
        SupportModelSelect select;
        CLIENT_LLM_SITES.clear();
        CLIENT_TTS_SITES.clear();
        for (String key : llmSites.keySet()) {
            LLMSite llmSite = llmSites.get(key);
            if (!llmSite.enabled()) continue;
            if (llmSite instanceof SupportModelSelect) {
                select = (SupportModelSelect)((Object)llmSite);
                CLIENT_LLM_SITES.put(key, select.models());
                continue;
            }
            CLIENT_LLM_SITES.put(key, Collections.emptyMap());
        }
        for (String key : ttsSites.keySet()) {
            TTSSite ttsSite = ttsSites.get(key);
            if (!ttsSite.enabled()) continue;
            if (ttsSite instanceof SupportModelSelect) {
                select = (SupportModelSelect)((Object)ttsSite);
                CLIENT_TTS_SITES.put(key, select.models());
                continue;
            }
            CLIENT_TTS_SITES.put(key, Collections.emptyMap());
        }
    }

    public static Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> readFromNetwork(class_2540 buf) {
        LinkedHashMap llmSites = Maps.newLinkedHashMap();
        LinkedHashMap ttsSites = Maps.newLinkedHashMap();
        int llmSize = buf.readInt();
        for (int i = 0; i < llmSize; ++i) {
            String key = buf.method_19772();
            Map<String, String> models = ClientAvailableSitesSync.readMapFromNetwork(buf);
            llmSites.put(key, models);
        }
        int ttsSize = buf.readInt();
        for (int i = 0; i < ttsSize; ++i) {
            String key = buf.method_19772();
            Map<String, String> models = ClientAvailableSitesSync.readMapFromNetwork(buf);
            ttsSites.put(key, models);
        }
        return Pair.of((Object)llmSites, (Object)ttsSites);
    }

    public static void writeToNetwork(class_2540 buf) {
        buf.writeInt(CLIENT_LLM_SITES.size());
        for (Map.Entry<String, Map<String, String>> entry : CLIENT_LLM_SITES.entrySet()) {
            buf.method_10814(entry.getKey());
            ClientAvailableSitesSync.writeMapToNetwork(buf, entry.getValue());
        }
        buf.writeInt(CLIENT_TTS_SITES.size());
        for (Map.Entry<String, Map<String, String>> entry : CLIENT_TTS_SITES.entrySet()) {
            buf.method_10814(entry.getKey());
            ClientAvailableSitesSync.writeMapToNetwork(buf, entry.getValue());
        }
    }

    public static Map<String, Map<String, String>> getClientLLMSites() {
        return CLIENT_LLM_SITES;
    }

    public static Map<String, Map<String, String>> getClientTTSSites() {
        return CLIENT_TTS_SITES;
    }

    private static Map<String, String> readMapFromNetwork(class_2540 buf) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String key = buf.method_19772();
            String value = buf.method_19772();
            map.put(key, value);
        }
        return map;
    }

    private static void writeMapToNetwork(class_2540 buf, Map<String, String> map) {
        buf.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buf.method_10814(entry.getKey());
            buf.method_10814(entry.getValue());
        }
    }
}

