/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.backpack;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3908;
import net.minecraft.class_4587;
import net.minecraft.class_5599;
import net.minecraft.class_583;

public abstract class IMaidBackpack {
    public abstract class_2960 getId();

    public abstract class_1792 getItem();

    public abstract void onPutOn(class_1799 var1, class_1657 var2, EntityMaid var3);

    public class_1799 getTakeOffItemStack(class_1799 stack, @Nullable class_1657 player, EntityMaid maid) {
        return this.getItem().method_7854();
    }

    public abstract void onTakeOff(class_1799 var1, class_1657 var2, EntityMaid var3);

    public abstract void onSpawnTombstone(EntityMaid var1, EntityTombstone var2);

    public abstract class_3908 getGuiProvider(int var1);

    public boolean hasBackpackData() {
        return false;
    }

    @Nullable
    public IBackpackData getBackpackData(EntityMaid maid) {
        return null;
    }

    public abstract int getAvailableMaxContainerIndex();

    @Environment(value=EnvType.CLIENT)
    public abstract void offsetBackpackItem(class_4587 var1);

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public abstract class_583<EntityMaid> getBackpackModel(class_5599 var1);

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public abstract class_2960 getBackpackTexture();

    protected final void dropAllItems(EntityMaid maid) {
        ItemsUtil.dropEntityItems((class_1297)maid, maid.getMaidInv(), 6);
    }

    protected final void dropRelativeItems(class_1799 stack, EntityMaid maid) {
        BackpackManager.findBackpack(stack).ifPresentOrElse(backpack -> {
            int startIndex = backpack.getAvailableMaxContainerIndex();
            ItemsUtil.dropEntityItems((class_1297)maid, maid.getMaidInv(), startIndex);
        }, () -> this.dropAllItems(maid));
    }
}

