/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.entity;

import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.api.event.ConvertMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.BackpackManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.util.BiomeCacheUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public interface IMaid {
    @Nullable
    public static IMaid convert(class_1308 mob) {
        if (mob instanceof IMaid) {
            IMaid maid = (IMaid)mob;
            return maid;
        }
        ConvertMaidEvent event = new ConvertMaidEvent(mob);
        ((ConvertMaidEvent.Callback)ConvertMaidEvent.CALLBACK.invoker()).post(event);
        return event.getMaid();
    }

    @Nullable
    public static EntityMaid convertToMaid(class_1308 mob) {
        IMaid convert = IMaid.convert(mob);
        if (convert == null) {
            return null;
        }
        return convert.asStrictMaid();
    }

    @Nullable
    default public EntityMaid asStrictMaid() {
        return null;
    }

    public String getModelId();

    default public boolean isYsmModel() {
        return false;
    }

    default public void setIsYsmModel(boolean isYsmModel) {
    }

    default public String getYsmModelId() {
        return "";
    }

    default public String getYsmModelTexture() {
        return "";
    }

    default public class_2561 getYsmModelName() {
        return class_2561.method_43473();
    }

    default public void setYsmModel(String modelId, String texture, class_2561 name) {
    }

    default public void playRouletteAnim(String rouletteAnim) {
    }

    default public void stopRouletteAnim() {
    }

    public class_1308 asEntity();

    default public class_1799[] getHandItemsForAnimation() {
        return new class_1799[]{class_1799.field_8037, class_1799.field_8037};
    }

    default public IMaidTask getTask() {
        return TaskManager.getIdleTask();
    }

    default public boolean isSwingingArms() {
        return false;
    }

    default public int getExperience() {
        return 0;
    }

    default public boolean isMaidInSittingPose() {
        return false;
    }

    default public boolean isBegging() {
        return false;
    }

    default public int getFavorability() {
        return 0;
    }

    default public class_1799 getBackpackShowItem() {
        return class_1799.field_8037;
    }

    default public IMaidBackpack getMaidBackpackType() {
        return BackpackManager.getEmptyBackpack();
    }

    default public boolean hasBackpack() {
        return this.getMaidBackpackType() != BackpackManager.getEmptyBackpack();
    }

    default public boolean hasHelmet() {
        return !this.asEntity().method_6118(class_1304.field_6169).method_7960();
    }

    default public boolean hasChestPlate() {
        return !this.asEntity().method_6118(class_1304.field_6174).method_7960();
    }

    default public boolean hasLeggings() {
        return !this.asEntity().method_6118(class_1304.field_6172).method_7960();
    }

    default public boolean hasBoots() {
        return !this.asEntity().method_6118(class_1304.field_6166).method_7960();
    }

    default public boolean onHurt() {
        return this.asEntity().field_6235 > 0;
    }

    default public boolean hasFishingHook() {
        return false;
    }

    default public boolean method_6101() {
        return false;
    }

    @Deprecated
    default public String getAtBiomeTemp() {
        float temp = BiomeCacheUtil.getCacheBiome((class_1297)this.asEntity()).method_8712();
        if ((double)temp < 0.15) {
            return "COLD";
        }
        if ((double)temp < 0.55) {
            return "OCEAN";
        }
        if ((double)temp < 0.95) {
            return "MEDIUM";
        }
        return "WARM";
    }

    @Deprecated
    default public boolean hasSasimono() {
        return false;
    }

    @Deprecated
    default public boolean isSitInJoyBlock() {
        return false;
    }

    @Deprecated
    default public int getDim() {
        class_5321 dim = this.asEntity().field_6002.method_27983();
        if (dim.equals(class_1937.field_25179)) {
            return 0;
        }
        if (dim.equals(class_1937.field_25180)) {
            return -1;
        }
        if (dim.equals(class_1937.field_25181)) {
            return 1;
        }
        return 0;
    }
}

