/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.sound.pojo.SoundPackInfo;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_1044;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.apache.commons.lang3.StringUtils;

public class SoundPackButton
extends FlatColorButton {
    private static final class_2960 ICON = new class_2960("touhou_little_maid", "textures/gui/maid_custom_sound.png");
    private final SoundPackInfo info;
    private boolean isUse = false;

    public SoundPackButton(int pX, int pY, SoundPackInfo info, class_4185.class_4241 onPress) {
        super(pX, pY, 230, 43, (class_2561)class_2561.method_43473(), onPress);
        this.info = info;
    }

    @Override
    public void method_48579(class_332 graphics, int mouseX, int mouseY, float pPartialTick) {
        super.method_48579(graphics, mouseX, mouseY, pPartialTick);
        class_2960 icon = this.info.getIcon();
        if (icon == null) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)ICON);
            graphics.method_25290(ICON, this.method_46426() + 4, this.method_46427() + 5, 0.0f, 16.0f, 32, 32, 256, 256);
        } else {
            if (this.info.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                this.checkIconAnimation(this.info, icon);
            }
            if (this.info.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                graphics.method_25290(icon, this.method_46426() + 4, this.method_46427() + 5, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)icon);
                int time = this.getTickTime() / this.info.getIconDelay();
                int iconIndex = time % this.info.getIconAspectRatio();
                graphics.method_25290(icon, this.method_46426() + 4, this.method_46427() + 5, 0.0f, (float)(iconIndex * 32), 32, 32, 32, 32 * this.info.getIconAspectRatio());
            }
        }
        if (this.isUse) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)ICON);
            graphics.method_25290(ICON, this.method_46426() + this.method_25368() - 20, this.method_46427() + 13, 32.0f, 0.0f, 16, 16, 256, 256);
        }
    }

    @Override
    public void method_48589(class_332 graphics, class_327 font, int pColor) {
        int startX = this.method_46426() + 42;
        int startY = this.method_46427() + 7;
        class_5250 packName = ParseI18n.parse(this.info.getPackName());
        String version = this.info.getVersion();
        List<String> author = this.info.getAuthor();
        String date = this.info.getDate();
        graphics.method_27535(font, (class_2561)packName, startX, startY, class_124.field_1068.method_532().intValue());
        if (StringUtils.isNotBlank((CharSequence)version)) {
            int titleWidth = font.method_27525((class_5348)packName);
            graphics.method_25303(font, "\u00a7nv" + version, startX + titleWidth + 5, startY, class_124.field_1075.method_532().intValue());
        }
        if (!author.isEmpty()) {
            String authorListText = StringUtils.joinWith((String)class_1074.method_4662((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), (Object[])new Object[]{author});
            String authorText = class_1074.method_4662((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{authorListText});
            graphics.method_25303(font, authorText, startX, startY += 10, class_124.field_1065.method_532().intValue());
        }
        if (StringUtils.isNotBlank((CharSequence)date)) {
            class_5250 dateText = class_2561.method_43469((String)"gui.touhou_little_maid.skin.text.date", (Object[])new Object[]{date});
            graphics.method_27535(font, (class_2561)dateText, startX, startY += 10, class_124.field_1060.method_532().intValue());
        }
    }

    private int getTickTime() {
        return (int)System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(SoundPackInfo info, class_2960 icon) {
        class_1044 iconText = class_310.method_1551().method_1531().method_4619(icon);
        if (iconText instanceof SizeTexture) {
            int height;
            int width = ((SizeTexture)iconText).getWidth();
            if (width >= (height = ((SizeTexture)iconText).getHeight())) {
                info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                info.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                info.setIconAspectRatio(height / width);
            }
        } else {
            info.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    public boolean isUse() {
        return this.isUse;
    }

    public void setUse(boolean use) {
        this.isUse = use;
    }
}

