/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityChairRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.ChairModelInfo;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_922;

public class EntityChairRenderer
extends class_922<EntityChair, BedrockModel<EntityChair>> {
    public static final class_2960 DEFAULT_TEXTURE = new class_2960("touhou_little_maid", "textures/entity/empty.png");
    private static final String DEFAULT_CHAIR_ID = "touhou_little_maid:cushion";
    public static boolean renderHitBox = true;
    private ChairModelInfo chairInfo;
    private List<Object> chairAnimations;
    private final GeckoEntityChairRenderer geckoEntityChairRenderer;

    public EntityChairRenderer(class_5617.class_5618 rendererManager) {
        super(rendererManager, new BedrockModel(), 0.0f);
        this.geckoEntityChairRenderer = new GeckoEntityChairRenderer(rendererManager);
    }

    public void render(EntityChair chair, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        class_746 player = class_310.method_1551().field_1724;
        if (this.canShowHitBox((class_1657)player) && renderHitBox) {
            this.renderHitBox(chair, poseStack, bufferIn);
        } else {
            this.renderChair(chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        }
    }

    private boolean canShowHitBox(@Nullable class_1657 player) {
        if (player != null && player.method_5715()) {
            return player.method_6047().method_7909() == InitItems.CHAIR_SHOW;
        }
        return false;
    }

    private void renderHitBox(EntityChair chair, class_4587 poseStack, class_4597 bufferIn) {
        class_238 aabb = chair.method_5829().method_989(-chair.method_23317(), -chair.method_23318(), -chair.method_23321());
        class_761.method_22982((class_4587)poseStack, (class_4588)bufferIn.getBuffer(class_1921.method_23594()), (class_238)aabb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void renderChair(EntityChair chair, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 bufferIn, int packedLightIn) {
        CustomPackLoader.CHAIR_MODELS.getModel(DEFAULT_CHAIR_ID).ifPresent(model -> {
            this.field_4737 = model;
        });
        CustomPackLoader.CHAIR_MODELS.getInfo(DEFAULT_CHAIR_ID).ifPresent(info -> {
            this.chairInfo = info;
        });
        this.chairAnimations = null;
        CustomPackLoader.CHAIR_MODELS.getModel(chair.getModelId()).ifPresent(model -> {
            this.field_4737 = model;
        });
        CustomPackLoader.CHAIR_MODELS.getInfo(chair.getModelId()).ifPresent(info -> {
            this.chairInfo = info;
        });
        CustomPackLoader.CHAIR_MODELS.getAnimation(chair.getModelId()).ifPresent(animations -> {
            this.chairAnimations = animations;
        });
        if (this.chairInfo.isGeckoModel()) {
            this.geckoEntityChairRenderer.setMainInfo(this.chairInfo);
            this.geckoEntityChairRenderer.getAnimatableEntity(chair).setChair(this.chairInfo);
            this.geckoEntityChairRenderer.method_4054(chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            return;
        }
        ((BedrockModel)this.field_4737).setAnimations(this.chairAnimations);
        GlWrapper.setPoseStack(poseStack);
        super.method_4054((class_1309)chair, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        GlWrapper.clearPoseStack();
    }

    protected void scale(EntityChair chair, class_4587 poseStack, float partialTickTime) {
        float scale = this.chairInfo.getRenderEntityScale();
        poseStack.method_22905(scale, scale, scale);
    }

    public class_2960 getTextureLocation(EntityChair entity) {
        if (this.chairInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return this.chairInfo.getTexture();
    }

    protected void setupRotations(EntityChair chair, class_4587 poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - rotationYaw));
    }

    protected boolean shouldShowName(EntityChair entity) {
        return entity.method_5733();
    }
}

