/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.resource.pojo;

import com.github.tartaricacid.touhoulittlemaid.client.resource.GeckoModelLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class ChairModelInfo
implements IModelInfo {
    private static final float RENDER_ENTITY_SCALE_MIN = 0.2f;
    private static final float RENDER_ENTITY_SCALE_MAX = 2.0f;
    private static final String GECKO_ANIMATION = ".json";
    @SerializedName(value="name")
    private String name;
    @SerializedName(value="description")
    private List<String> description;
    @SerializedName(value="model")
    private class_2960 model;
    @SerializedName(value="texture")
    private class_2960 texture;
    @SerializedName(value="extra_textures")
    private List<class_2960> extraTextures;
    @SerializedName(value="model_id")
    private class_2960 modelId;
    @SerializedName(value="render_item_scale")
    private float renderItemScale = 1.0f;
    @SerializedName(value="render_entity_scale")
    private float renderEntityScale = 1.0f;
    @SerializedName(value="animation")
    private List<class_2960> animation;
    @SerializedName(value="mounted_height")
    private float mountedYOffset;
    @SerializedName(value="tameable_can_ride")
    private boolean tameableCanRide = true;
    @SerializedName(value="no_gravity")
    private boolean noGravity = false;
    @SerializedName(value="is_gecko")
    private boolean isGeckoModel = false;
    @Expose(deserialize=false, serialize=false)
    private class_2960 cacheIconId = null;

    @Override
    public class_2960 getTexture() {
        return this.texture;
    }

    @Override
    public List<class_2960> getExtraTextures() {
        return this.extraTextures;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getDescription() {
        return this.description;
    }

    @Override
    @Nullable
    public List<class_2960> getAnimation() {
        return this.animation;
    }

    @Override
    public class_2960 getModelId() {
        return this.modelId;
    }

    @Override
    public class_2960 getModel() {
        return this.model;
    }

    @Override
    public boolean isGeckoModel() {
        return this.isGeckoModel;
    }

    public float getMountedYOffset() {
        return this.mountedYOffset;
    }

    public boolean isTameableCanRide() {
        return this.tameableCanRide;
    }

    @Override
    public float getRenderItemScale() {
        return this.renderItemScale;
    }

    public float getRenderEntityScale() {
        return this.renderEntityScale;
    }

    public boolean isNoGravity() {
        return this.noGravity;
    }

    @Override
    public class_2960 getCacheIconId() {
        return this.cacheIconId;
    }

    public ChairModelInfo extra(class_2960 newModelId, class_2960 texture) {
        ChairModelInfo cloneInfo = new ChairModelInfo();
        cloneInfo.modelId = newModelId;
        cloneInfo.texture = texture;
        cloneInfo.cacheIconId = IModelInfo.createCacheIconId(newModelId);
        cloneInfo.name = this.name;
        cloneInfo.description = this.description;
        cloneInfo.model = this.model;
        cloneInfo.renderItemScale = this.renderItemScale;
        cloneInfo.renderEntityScale = this.renderEntityScale;
        cloneInfo.animation = this.animation;
        cloneInfo.mountedYOffset = this.mountedYOffset;
        cloneInfo.tameableCanRide = this.tameableCanRide;
        cloneInfo.noGravity = this.noGravity;
        cloneInfo.isGeckoModel = this.isGeckoModel;
        return cloneInfo;
    }

    public ChairModelInfo decorate() {
        if (this.description == null) {
            this.description = Collections.EMPTY_LIST;
        }
        if (this.modelId == null) {
            throw new JsonSyntaxException("Expected \"model_id\" in model");
        }
        this.cacheIconId = IModelInfo.createCacheIconId(this.modelId);
        if (this.model == null) {
            this.model = new class_2960(this.modelId.method_12836(), "models/entity/" + this.modelId.method_12832() + GECKO_ANIMATION);
        }
        if (this.texture == null) {
            this.texture = new class_2960(this.modelId.method_12836(), "textures/entity/" + this.modelId.method_12832() + ".png");
        }
        if (this.name == null) {
            this.name = String.format("{model.%s.%s.name}", this.modelId.method_12836(), this.modelId.method_12832());
        }
        if (this.isGeckoModel) {
            this.animation = this.animation == null || this.animation.isEmpty() ? Collections.singletonList(GeckoModelLoader.DEFAULT_CHAIR_ANIMATION) : this.animation.stream().filter(res -> res.method_12832().endsWith(GECKO_ANIMATION)).collect(Collectors.toList());
        }
        this.renderEntityScale = class_3532.method_15363((float)this.renderEntityScale, (float)0.2f, (float)2.0f);
        this.mountedYOffset = (this.mountedYOffset - 3.0f) * 0.0625f;
        return this;
    }
}

