/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.CombinedInvWrapper;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;

public class MaidFarmPlantTask
extends class_4097<EntityMaid> {
    private final IFarmTask task;

    public MaidFarmPlantTask(IFarmTask task) {
        super((Map)ImmutableMap.of(InitEntities.TARGET_POS, (Object)class_4141.field_18456));
        this.task = task;
    }

    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid owner) {
        class_4095<EntityMaid> brain = owner.method_18868();
        return brain.method_18904(InitEntities.TARGET_POS).map(targetPos -> {
            class_243 targetV3d = targetPos.method_18991();
            if (owner.method_5707(targetV3d) > Math.pow(this.task.getCloseEnoughDist(), 2.0)) {
                Optional walkTarget = brain.method_18904(class_4140.field_18445);
                if (walkTarget.isEmpty() || !((class_4142)walkTarget.get()).method_19094().method_18991().equals((Object)targetV3d)) {
                    brain.method_18875(InitEntities.TARGET_POS);
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    protected void start(class_3218 world, EntityMaid maid, long gameTimeIn) {
        maid.method_18868().method_18904(InitEntities.TARGET_POS).ifPresent(posWrapper -> {
            class_2338 basePos = posWrapper.method_18989();
            class_2338 cropPos = basePos.method_10084();
            class_2680 cropState = world.method_8320(cropPos);
            if (maid.canDestroyBlock(cropPos) && this.task.canHarvest(maid, cropPos, cropState)) {
                this.task.harvest(maid, cropPos, cropState);
                maid.method_6104(class_1268.field_5808);
                maid.method_18868().method_18875(InitEntities.TARGET_POS);
                maid.method_18868().method_18875(class_4140.field_18445);
                class_1309 patt0$temp = maid.method_35057();
                if (patt0$temp instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)patt0$temp;
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_farm");
                }
            }
            CombinedInvWrapper availableInv = maid.getAvailableInv(true);
            List<Integer> slots = ItemsUtil.getFilterStackSlots(availableInv, this.task::isSeed);
            if (!slots.isEmpty()) {
                for (int slot : slots) {
                    class_1799 seed = availableInv.getStackInSlot(slot);
                    class_2680 baseState = world.method_8320(basePos);
                    if (!this.task.canPlant(maid, basePos, baseState, seed)) continue;
                    class_1799 remain = this.task.plant(maid, basePos, baseState, seed);
                    availableInv.setStackInSlot(slot, remain);
                    maid.method_6104(class_1268.field_5808);
                    maid.method_18868().method_18875(InitEntities.TARGET_POS);
                    maid.method_18868().method_18875(class_4140.field_18445);
                    class_1309 patt0$temp = maid.method_35057();
                    if (patt0$temp instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)patt0$temp;
                        InitTrigger.MAID_EVENT.trigger(serverPlayer, "maid_farm");
                    }
                    return;
                }
            }
        });
    }
}

