/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.implement;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.IChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.chatbubble.implement.ImageChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.IChatBubbleData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class ImageChatBubbleData
implements IChatBubbleData {
    public static final class_2960 ID = new class_2960("touhou_little_maid", "image");
    private final int existTick;
    private final class_2960 bg;
    private final class_2960 image;
    private final int width;
    private final int height;
    private final int uOffset;
    private final int vOffset;
    private final int textureWidth;
    private final int textureHeight;
    private final int priority;
    @Environment(value=EnvType.CLIENT)
    private IChatBubbleRenderer renderer;

    private ImageChatBubbleData(int existTick, class_2960 bg, class_2960 image, int width, int height, int uOffset, int vOffset, int textureWidth, int textureHeight, int priority) {
        this.existTick = existTick;
        this.bg = bg;
        this.image = image;
        this.width = width;
        this.height = height;
        this.uOffset = uOffset;
        this.vOffset = vOffset;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.priority = priority;
    }

    public static ImageChatBubbleData create(class_2960 image, int width, int height) {
        return new ImageChatBubbleData(300, TYPE_2, image, width, height, 0, 0, 256, 256, 0);
    }

    public static ImageChatBubbleData create(class_2960 image, int width, int height, int uOffset, int vOffset) {
        return new ImageChatBubbleData(300, TYPE_2, image, width, height, uOffset, vOffset, 256, 256, 0);
    }

    public static ImageChatBubbleData create(int existTick, class_2960 bg, class_2960 image, int width, int height, int uOffset, int vOffset, int textureWidth, int textureHeight, int priority) {
        return new ImageChatBubbleData(existTick, bg, image, width, height, uOffset, vOffset, textureWidth, textureHeight, priority);
    }

    @Override
    public int existTick() {
        return this.existTick;
    }

    @Override
    public class_2960 id() {
        return ID;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public IChatBubbleRenderer getRenderer(IChatBubbleRenderer.Position position) {
        if (this.renderer == null) {
            this.renderer = new ImageChatBubbleRenderer(this.width, this.height, this.uOffset, this.vOffset, this.textureWidth, this.textureHeight, this.bg, this.image);
        }
        return this.renderer;
    }

    public static class ImageChatSerializer
    implements IChatBubbleData.ChatSerializer {
        @Override
        public IChatBubbleData readFromBuff(class_2540 buf) {
            int width = buf.method_10816();
            int height = buf.method_10816();
            int uOffset = buf.method_10816();
            int vOffset = buf.method_10816();
            int textureWidth = buf.method_10816();
            int textureHeight = buf.method_10816();
            class_2960 bg = buf.method_10810();
            class_2960 image = buf.method_10810();
            return new ImageChatBubbleData(300, bg, image, width, height, uOffset, vOffset, textureWidth, textureHeight, 0);
        }

        @Override
        public void writeToBuff(class_2540 buf, IChatBubbleData data) {
            ImageChatBubbleData imageChat = (ImageChatBubbleData)data;
            buf.method_10804(imageChat.width);
            buf.method_10804(imageChat.height);
            buf.method_10804(imageChat.uOffset);
            buf.method_10804(imageChat.vOffset);
            buf.method_10804(imageChat.textureWidth);
            buf.method_10804(imageChat.textureHeight);
            buf.method_10812(imageChat.bg);
            buf.method_10812(imageChat.image);
        }
    }
}

