/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class MaidGameRecordManager {
    private static final String GAME_SKILL_TAG = "MaidGameSkillData";
    private static final String GOMOKU = "Gomoku";
    private static final byte NONE = 0;
    private static final byte WIN = 1;
    private static final byte LOSE = 2;
    private final EntityMaid maid;

    public MaidGameRecordManager(EntityMaid maid) {
        this.maid = maid;
    }

    void defineSynchedData() {
        this.maid.method_5841().method_12784(EntityMaid.GAME_SKILL, (Object)new class_2487());
        this.maid.method_5841().method_12784(EntityMaid.GAME_STATUE, (Object)0);
    }

    void addAdditionalSaveData(class_2487 compound) {
        compound.method_10566(GAME_SKILL_TAG, (class_2520)this.getGameSkill());
    }

    void readAdditionalSaveData(class_2487 compound) {
        if (compound.method_10573(GAME_SKILL_TAG, 10)) {
            this.setGameSkill(compound.method_10562(GAME_SKILL_TAG));
        }
    }

    void tick() {
        if (!(this.maid.method_5854() instanceof EntitySit) && this.getGameStatue() != 0) {
            this.resetStatue();
        }
    }

    private class_2487 getGameSkill() {
        return (class_2487)this.maid.method_5841().method_12789(EntityMaid.GAME_SKILL);
    }

    private void setGameSkill(class_2487 gameSkill) {
        this.maid.method_5841().method_49743(EntityMaid.GAME_SKILL, (Object)gameSkill, true);
    }

    private byte getGameStatue() {
        return (Byte)this.maid.method_5841().method_12789(EntityMaid.GAME_STATUE);
    }

    private void setGameStatue(byte gameStatue) {
        this.maid.method_5841().method_12778(EntityMaid.GAME_STATUE, (Object)gameStatue);
    }

    public int getGomokuWinCount() {
        class_2487 gameSkill = this.getGameSkill();
        if (gameSkill.method_10573(GOMOKU, 3)) {
            return gameSkill.method_10550(GOMOKU);
        }
        return 0;
    }

    public void increaseGomokuWinCount() {
        class_2487 gameSkill = this.getGameSkill();
        if (gameSkill.method_10573(GOMOKU, 3)) {
            gameSkill.method_10569(GOMOKU, gameSkill.method_10550(GOMOKU) + 1);
        } else {
            gameSkill.method_10569(GOMOKU, 1);
        }
        this.setGameSkill(gameSkill);
    }

    public boolean isWin() {
        return this.getGameStatue() == 1;
    }

    public boolean isLost() {
        return this.getGameStatue() == 2;
    }

    public void markStatue(boolean isWin) {
        this.setGameStatue(isWin ? (byte)1 : 2);
        if (isWin) {
            this.maid.method_5783(InitSounds.GAME_WIN, 1.0f, 1.0f);
        } else {
            this.maid.method_5783(InitSounds.GAME_LOST, 1.0f, 1.0f);
        }
    }

    public void resetStatue() {
        this.setGameStatue((byte)0);
    }
}

