/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.SlotItemHandler;
import com.github.tartaricacid.touhoulittlemaid.entity.backpack.data.FurnaceBackpackData;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1719;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3913;
import net.minecraft.class_3917;

public class FurnaceBackpackContainer
extends MaidMainContainer {
    public static final class_3917<FurnaceBackpackContainer> TYPE = new ExtendedScreenHandlerType((id, inv, data) -> new FurnaceBackpackContainer(id, inv, data.readInt()));
    private final class_3913 data;

    public FurnaceBackpackContainer(int id, class_1661 inventory, int entityId) {
        super(TYPE, id, inventory, entityId);
        FurnaceBackpackData furnaceData = this.getMaid().getBackpackData() instanceof FurnaceBackpackData ? (FurnaceBackpackData)this.getMaid().getBackpackData() : new FurnaceBackpackData(this.getMaid());
        this.data = furnaceData.getDataAccess();
        this.method_7621(new class_1735((class_1263)furnaceData, 0, 161, 101){

            public boolean method_7680(class_1799 stack) {
                return EntityMaid.canInsertItem(stack);
            }
        });
        this.method_7621(new FurnaceBackpackFuelSlot(this, (class_1263)furnaceData, 1, 161, 142));
        this.method_7621((class_1735)new class_1719(inventory.field_7546, (class_1263)furnaceData, 2, 221, 121));
        this.method_17360(this.data);
    }

    @Override
    protected void addBackpackInv(class_1661 inventory) {
        int i;
        ItemStackHandler itemHandler = this.maid.getMaidInv();
        for (i = 0; i < 6; ++i) {
            this.method_7621(new SlotItemHandler(itemHandler, 6 + i, 143 + 18 * i, 57));
        }
        for (i = 0; i < 6; ++i) {
            this.method_7621(new SlotItemHandler(itemHandler, 12 + i, 143 + 18 * i, 75));
        }
    }

    private boolean isFuel(class_1799 stack) {
        Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
        return burnTime != null && burnTime > 0;
    }

    public int getBurnProgress() {
        int cookingProgress = this.data.method_17390(2);
        int cookingTotalTime = this.data.method_17390(3);
        return cookingTotalTime != 0 && cookingProgress != 0 ? cookingProgress * 24 / cookingTotalTime : 0;
    }

    public int getLitProgress() {
        int litDuration = this.data.method_17390(1);
        if (litDuration == 0) {
            litDuration = 200;
        }
        return this.data.method_17390(0) * 13 / litDuration;
    }

    public boolean isLit() {
        return this.data.method_17390(0) > 0;
    }

    public static class FurnaceBackpackFuelSlot
    extends class_1735 {
        private final FurnaceBackpackContainer furnaceBackpackContainer;

        public FurnaceBackpackFuelSlot(FurnaceBackpackContainer furnaceBackpackContainer, class_1263 container, int slot, int pX, int pY) {
            super(container, slot, pX, pY);
            this.furnaceBackpackContainer = furnaceBackpackContainer;
        }

        public boolean method_7680(class_1799 stack) {
            return this.furnaceBackpackContainer.isFuel(stack) || FurnaceBackpackFuelSlot.isBucket(stack);
        }

        public int method_7676(class_1799 stack) {
            return FurnaceBackpackFuelSlot.isBucket(stack) ? 1 : super.method_7676(stack);
        }

        public static boolean isBucket(class_1799 stack) {
            return stack.method_31574(class_1802.field_8550);
        }
    }
}

