/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.handler;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemStackHandler;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.item.bauble.BaubleManager;
import java.util.Arrays;
import java.util.function.BiPredicate;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public class BaubleItemHandler
extends ItemStackHandler {
    private IMaidBauble[] baubles;

    public BaubleItemHandler() {
        this(1);
    }

    public BaubleItemHandler(int size) {
        super(size);
        this.baubles = new IMaidBauble[size];
    }

    public BaubleItemHandler(class_2371<class_1799> stacks) {
        super(stacks);
        this.baubles = new IMaidBauble[stacks.size()];
        IntStream.range(0, this.getSlots()).forEach(this::onContentsChanged);
    }

    @Override
    public void setSize(int size) {
        if (size == this.stacks.size()) {
            Arrays.fill(this.baubles, null);
        } else {
            this.baubles = new IMaidBauble[this.stacks.size()];
        }
        super.setSize(size);
    }

    private void setBaubleInSlot(int slot, @Nullable IMaidBauble bauble) {
        this.validateSlotIndex(slot);
        this.baubles[slot] = bauble;
    }

    @Nullable
    public IMaidBauble getBaubleInSlot(int slot) {
        class_1799 stack = this.getStackInSlot(slot);
        if (stack.method_7960()) {
            return null;
        }
        return this.baubles[slot];
    }

    @Override
    protected void onContentsChanged(int slot) {
        class_1799 stack = this.getStackInSlot(slot);
        if (stack.method_7960()) {
            this.setBaubleInSlot(slot, null);
        } else {
            this.setBaubleInSlot(slot, BaubleManager.getBauble(stack));
        }
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull class_1799 stack) {
        return BaubleManager.getBauble(stack) != null;
    }

    @Override
    @Nonnull
    public class_1799 insertItem(int slot, @Nonnull class_1799 stack, boolean simulate) {
        if (this.isItemValid(slot, stack)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Override
    protected void onLoad() {
        IntStream.range(0, this.getSlots()).forEach(this::onContentsChanged);
    }

    public boolean fireEvent(BiPredicate<IMaidBauble, class_1799> function) {
        for (int i = 0; i < this.getSlots(); ++i) {
            class_1799 stack = this.getStackInSlot(i);
            IMaidBauble bauble = this.getBaubleInSlot(i);
            if (stack.method_7960() || bauble == null || !function.test(bauble, stack)) continue;
            return true;
        }
        return false;
    }
}

