/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.DefaultMonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.AttackTaskConfigContainer;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4140;
import net.minecraft.class_7923;

public interface IAttackTask
extends IMaidTask {
    public static final String MAID_NO_ATTACK_TAG = "MaidNoAttack";

    public static Optional<? extends class_1309> findFirstValidAttackTarget(EntityMaid maid) {
        return maid.method_18868().method_18904(class_4140.field_18442).flatMap(mobs -> mobs.method_38975(e -> maid.method_18395((class_1309)e) && maid.method_18407(e.method_24515())));
    }

    default public boolean canAttack(EntityMaid maid, class_1309 target) {
        class_1321 tamableAnimal;
        class_2960 id = class_7923.field_41177.method_10221((Object)target.method_5864());
        if (target instanceof class_1531 || target instanceof AbstractEntityFromItem || target instanceof class_1657) {
            return false;
        }
        if (target instanceof class_1321 && (tamableAnimal = (class_1321)target).method_6139() != null) {
            return false;
        }
        if (target.method_5797() != null && target.method_5797().getString().startsWith(MAID_NO_ATTACK_TAG)) {
            return false;
        }
        if (((List)MaidConfig.MAID_ATTACK_IGNORE.get()).contains(id.toString())) {
            return false;
        }
        AttackListData attackListData = maid.getData(InitTaskData.ATTACK_LIST);
        MonsterType monsterType = attackListData != null && attackListData.attackGroups().containsKey(id) ? attackListData.attackGroups().get(id) : DefaultMonsterType.getMonsterType(target);
        return DefaultMonsterType.canAttack(maid, target, monsterType);
    }

    default public boolean hasExtraAttack(EntityMaid maid, class_1297 target) {
        return false;
    }

    default public boolean doExtraAttack(EntityMaid maid, class_1297 target) {
        return false;
    }

    default public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        return false;
    }

    @Override
    default public class_3908 getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.method_5628();
        return new ExtendedScreenHandlerFactory<Integer>(){

            public Integer getScreenOpeningData(class_3222 player) {
                return entityId;
            }

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Maid Attack Config Container");
            }

            public AbstractMaidContainer createMenu(int index, class_1661 playerInventory, class_1657 player) {
                return new AttackTaskConfigContainer(index, playerInventory, entityId);
            }

            public boolean shouldCloseCurrentScreen() {
                return false;
            }
        };
    }

    @Override
    default public boolean enablePanic(EntityMaid maid) {
        return false;
    }
}

